/*
Hello-world program for RTOS SDFileSystem

One thread stores time values in two buffers, the other thread
saves it on the SD card. Since the time thread has low priority
the SD thread will take what it needs. This then shows the reduced
overhead of the RTOS SDFileSystem compared to regular.

To test it yourself, delete SDFileSystem-RTOS, import the regular one.

The pinouts are for the Wi-Go2 board, but you can easily change it
*/

#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
 
DigitalOut SD_EN(PTE3);                         // Enable signal for SD Card, specific to Wi-Go2, most SD-card boards do not have this pin
                                                // In that case you can remove it, or assign it to a random pin you are not using
SDFileSystem sd(PTD6, PTD7, PTB11, PTE5, "sd"); // The pinout on the Wi-Go2 module (MOSI, MISO, SCLK, CS)

unsigned int buffer1[100];
unsigned int buffer2[100];

Thread *sd_pointer;

void timer_thread(void const *args) {
    Thread::wait(5000);
    
    Timer timey;
    int i = 0;
    printf("Starting timing!\r\n");
    
    timey.start();
    while (true) {
        //No RTOS wait here, but since it has low priority that should be fine
        if (i<100)
            buffer1[i]=timey.read_us();
        else if (i<200)
            buffer2[i-100]=timey.read_us();
        else
            break;
        
        if (i==99)
            sd_pointer->signal_set(0x1);
        if (i==199)
            sd_pointer->signal_set(0x2);
        i++;
    }
    printf("Timer is done\r\n");
}

void sd_thread(void const *args) {
    //Get ready
    mkdir("/sd/Wi-Go", 0777);
    mkdir("/sd/Wi-Go", 0777);
    
    printf("SD thread is ready\r\n");
    
    Thread::signal_wait(0x1);
    FILE *fp = fopen("/sd/Wi-Go/timer.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n\r");
    }
    for (int i = 0; i<100; i++)
        fprintf(fp, "%d\r\n",buffer1[i]);
    fclose(fp); 
    
    Thread::signal_wait(0x2);
    fp = fopen("/sd/Wi-Go/timer.txt", "a");
    if(fp == NULL) {
        error("Could not open file for write\n\r");
    }
    for (int i = 0; i<100; i++)
        fprintf(fp, "%d\r\n",buffer2[i]);
    fclose(fp); 
    
    printf("SD is done \r\n");
}

int main() {
    
    SD_EN = 1;                                  // Enable SD Card, wait a bit to make sure SD card is properly inserted
    wait(1);
    printf("Starting SD thread\r\n");
    Thread thread_sd(sd_thread);
    sd_pointer = &thread_sd;
    
    printf("Starting timer thread\r\n");
    Thread thread(timer_thread);
    thread.set_priority(osPriorityLow);
    Thread::wait(20000);
    printf("Main thread done\r\n");
    
    
}
