/* mbed USBMSD_Ram Library
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "Flash_USBFileSystem.h"
 
FlashUSB::FlashUSB(PinName mosi, PinName miso, PinName sclk, PinName cs) : USBFileSystem("USB"), flash(mosi, miso, sclk, cs)  {
    //no init
    _status = 0x01;
}
 
int FlashUSB::disk_initialize() {
    // OK
    _status = 0x00;
    return 0;
}
 
int FlashUSB::_disk_write(const uint8_t * buffer, uint64_t block_number) { 
    flash.eraseSector(block_number*4096);
    flash.write(block_number*4096, (char*) buffer, 256);
    flash.write(block_number*4096+256, (char*) buffer+256, 256);
    return 0;    
}
 
int FlashUSB::disk_read(uint8_t * buffer, uint64_t block_number) {
    flash.read(block_number*4096, (char*) buffer, 512);
    return 0;
}
 
int FlashUSB::_disk_status() { return _status; }
int FlashUSB::disk_sync() { return 0; }
uint64_t FlashUSB::disk_sectors() { return 512; }

    