#include "mbed.h"
#include "Flash_USBFileSystem.h"

DigitalOut myled(LED1);
FlashUSB flash(PTD6, PTD7, PTB11, PTE4);

void usbCallback(bool available)
{
    if (available) {
        FILE *fp = fopen("/USB/in.txt", "r");
        char buffer[100];
        fgets (buffer, 100, fp);
        printf("%s\r\n", buffer);
        fclose(fp);
    }
}

int main()
{
    flash.attachUSB(&usbCallback);
    
    wait(0.1);
    printf("Hello World!\r\n");

    FILE *fp = fopen("/USB/in.txt", "w");

    if(fp == NULL) {
        printf("Could not open file, assuming unformatted disk!\r\n");
        printf("Formatting disk!\r\n");
        flash.format();
        printf("Disk formatted!\r\n");
        printf("Reset your device!\r\n");
        while(1);
    } else {
        wait(0.2);
        fprintf(fp, "Type your text here!");
        fclose(fp);
    }

    //Connect USB
    flash.connect();
    flash.usbMode(1);       //Disconnect USB when files are locally written
    
    char buffer[101];
    printf("Type your text here! (100 max length)\n");
    while(1) {
        gets(buffer);
        myled = !myled;
        
        //Open file for write, keep trying until we succeed
        //This is needed because if USB happens to be writing it will fail
        while(1) {
            fp = fopen("/USB/out.txt", "w");
            if (fp != NULL)
                break;
            }
        fprintf(fp, buffer);
        fclose(fp);
        
    }

}
