#include "Mini_DK.h"
#include "mbed.h"
#include "RTC.h"

DigitalOut led(DK_LED1);

TouchScreenADS7843 TFT(TP_SDI ,TP_SDO ,TP_SCK ,TP_CS ,TP_IRQ ,LCD_SDI, LCD_SDO, LCD_SCK, LCD_CS, NC,"TFT");

void displayFunction( void )
{
    led = !led;
    TFT.locate(20,50);
    time_t seconds = time(NULL);
    char buffer[32];
    
    strftime(buffer, 32, "%H:%M:%S", localtime(&seconds));
    TFT.printf("%s", buffer);
}

int main()
{
    set_time(1256729737); // Set time to Wed, 28 Oct 2009 11:35:37
    TFT.TP_Init();

    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white


    
    TFT.cls();
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.set_orientation(1);
   
    
    RTC::attach(&displayFunction, RTC::Second);

    while(1) {}
}