/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#include "MODSERIAL.h"
#include "MACROS.h"

namespace AjK {

int
MODSERIAL::__putc(int c, bool block) {
    uint32_t lsr = (uint32_t)*((char *)_base + MODSERIAL_LSR);
    
    if ( dmaInUse[TxIrq] == NotInUse ) {
        if (lsr & 0x20 && MODSERIAL_TX_BUFFER_EMPTY ) {
            _THR = (uint32_t)c;
        }
        else {
            if (buffer[TxIrq] != (char *)NULL) {
                if (block) while ( MODSERIAL_TX_BUFFER_FULL ) ; // Blocks!
                else if( MODSERIAL_TX_BUFFER_FULL ) {
                    buffer_overflow[TxIrq] = c; // Oh dear, no room in buffer.
                    _isr[TxOvIrq].call();
                    return -1;
                }
                buffer[TxIrq][buffer_in[TxIrq]] = c;
                buffer_count[TxIrq]++;
                buffer_in[TxIrq]++;
                if (buffer_in[TxIrq] >= buffer_size[TxIrq]) {
                    buffer_in[TxIrq] = 0;
                }            
                _IER |= 0x2;
            }
        }
    }
    
    return 0;
}

}; // namespace AjK ends
