#include "mbed.h"
#include "WakeUp.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
InterruptIn inter(D0);


void interirq(void)
{
    led1 = 0;
    wait(0.2);
    led1 = 1;
}

void wakeirq(void)
{
    led2 = 0;
    wait(0.2);
    led2 = 1;
}

int main()
{
    led1 = 1;
    led2 = 1;
    inter.rise(interirq);
    WakeUp::calibrate();
    WakeUp::attach(wakeirq);


    //Disable BOD and WDT (only done to get nice low deepsleep power):
    LPC_SYSCON->PDRUNCFG |= (1<<3) | (1<<6);
 
    WakeUp::set(10);
    while(1) {
        //sleep();
        deepsleep();
        WakeUp::set(10);
    }
}

