/*Seriously no one cares about copyright stuff

But if you really want the license: If you make lots of money with my code, send me money, ty

Now usefull stuff*/


#ifndef IMUCALC_H
#define IMUCALC_H

/**
 * Includes
 */
#include "mbed.h"
#include "math.h"
#include "GTMath.h"

#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

class IMUCalc {
public:
    IMUCalc( void );
    
    /**
     * Calculates new headings
     *
     * @param accdat - pointer to float array with length 3 with acceleration data
     * @param gyrodat - pointer to float array with length 3 with gyroscope data
     * @param magdat - pointer to float array with length 3 with magnetic data
     * @param timestep - float with timestep in seconds
     */
    void runCalc(float *accdat, float *gyrodat, float *magdat, float timestep);
    
    /**
    * Returns the yaw
    *
    * @param return - float with yaw in rads
    */
    float getYaw( void );
    
    /**
    * Returns the pitch
    *
    * @param return - float with pitch in rads
    */
    float getPitch( void );
    
    /**
    * Returns the roll
    *
    * @param return - float with roll in rads
    */
    float getRoll( void );
    
    /**
    * Returns the calculated offset of the gyro
    *
    * @param return - Vector3 with gyro offsets
    */
    Vector3 getGyroOffset( void );



//private:
    /**
     * Rotates magnetic vector to be in plane
     *
     * @param magdat - Vector3 with magnetic data
     * @param ground - Vector3 with data which direction the ground is
     *
     * @param return - Vector3 with new magnetic vector
     */
    Vector3 rotateMag(Vector3 magdat, Vector3 ground);
    
    /**
     * Calculates the angle between two vectors
     *
     * @param vectorA - first vector
     * @param vectorB - second vector
     * @param return - vector with which to rotate vectorA to get vectorB
     */
    static Vector3 angleBetween(Vector3 vectorA, Vector3 VectorB);
    
    /**
     * Rotate a vector around an axis
     *
     * @param vector - vector to rotate
     * @param axis - axis to rotate it around
     * @param angle - angle to rotate the vectors
     * @param return - resulting vector
     */
    static Vector3 rotateVector(Vector3 vector, Vector3 axis, float angle);


    Vector3 heading;
    Vector3 top;
    Vector3 gyroOffset;
    
    float absGain;
    bool initialRun;

};

#endif