#ifndef GLOBAL_H
#define GLOBAL_H

#include "mbed.h"
#include <string>

/// @file Global.h
/// @brief Contains global variables and functions

/// A highscore element consists of initials and a score.
struct Highscore
{
    std::string initials;
    int score;
};

namespace Global
{
    /// Score in last game
    extern int score;
    
    /// List showing the three all time highest score achieved. Sorted from highest to lowest.
    extern Highscore highscores[3];        
    
    /// Clears the highscore list
    void clearHighscoreList();
}

#endif