#include "Joystick.h"
#include "mbed.h"
#include <cmath>

/// @file Joystick.cpp

Joystick::Joystick(PinName x, PinName y, PinName button)
{
    xPot = new AnalogIn(x);
    yPot = new AnalogIn(y);
    btn = new DigitalIn(button);
}

Joystick::~Joystick()
{
    delete xPot;
    delete yPot;
    delete btn;
}


// Make sure that the Joystick is centered while calibrating
void Joystick::calibrate()
{
    btn->mode(PullDown);
    centerX = *xPot;
    centerY = *yPot;
}


void Joystick::update()
{
    // Get position of joystick compared to the center values (delta x and delta y).
    dx = *xPot - centerX;
    dy = *yPot - centerY;
    
    if (abs(dx) < DEAD_ZONE && abs(dy) < DEAD_ZONE)
        dir = CENTER;
    else if (abs(dx) < DEAD_ZONE)                       // Inside horizontal dead zone.
        dir = (dy > DEAD_ZONE) ? UP : DOWN;
    else if (abs(dy) < DEAD_ZONE)                       // Inside vertical dead zone.
        dir = (dx > DEAD_ZONE) ? LEFT : RIGHT;
    else if (dx > 0)                                    // To the left, outside both deadzones.
        dir = (dy > 0) ? UP_LEFT : DOWN_LEFT; 
    else                                                // To the right, outside both deadzones
        dir = (dy > 0) ? UP_RIGHT : DOWN_RIGHT;
}
