#include "Enemy.h"

/// @file Enemy.cpp

/// Setup the enemy based on type
void Enemy::setup()
{   
    switch (type)
    {
        case SIMPLE:
            width = 5;
            height = 5;
            vx = 1;
            difficulty = 1;
            jumpRate = 3;
        break;
        
        case JUMPER:
            width = 3;
            height = 4;
            vx = 1;
            difficulty = 3;
            jumpRate = 50;
        break;
        
        case RUNNER:
            width = 6;
            height = 5;
            vx = 2;
            difficulty = 5;
            jumpRate = 0;
        break;
        
        default: // error, should not be possible
            width = height = vx = vy = 0;
    }
    
    if (facingLeft)
        vx *= -1;    
}