#ifndef MAIN_MENU_H
#define MAIN_MENU_H

/** @file MainMenu.h
*   @author Andreas Garmannslund
*   @date April 2015
*/

#include "State.h"
#include "Global.h"
#include <string>
#include <sstream>

/// State: Main Menu
class MainMenu : public State
{
    public:
        /// Creates a new MainMenu object
        MainMenu(StateManager* fsm, N5110 *lcd, InputManager* input, Sound *sound)
                : State(fsm, lcd, input, sound) {init();}
                
        /// Update logic
        virtual void update(float dt);
        
        /// Draw MainMenu to screen
        virtual void render();
    
    private:
        void init();
        static void btnAPress(); // Interrupt callback function when button A is pressed
        static void btnBPress(); // Interrupt callback function when button B is pressed
        static void btnCPress(); // Interrupt callback function when button C is pressed
        
    // Variables
    private:
        /// States for the main menu's internal finite state machine
        enum MenuState {SELECT_PLAY, SELECT_HIGHSCORES, SELECT_CONTROLS, LOAD_GAME, HIGHSCORES, CONTROLS};
        
        /// Current state of the internal finite state machine
        static int currentState;
        
        /** Transition table for internal fsm
        * Each row corresponds to a state
        * Each column corresponds to the button pressed
        */
        static const int MENU_FSM[6][3];
};

#endif