#ifndef INPUT_H
#define INPUT_H

#include "N5110.h"
#include "PinDetect.h"
#include "Joystick.h"

/// @file InputManager.h

struct Input
{
    /** Used as identificator for the different buttons */
    enum Button{ButtonA, ButtonB, ButtonC};
};

/// Used to manage user input from buttons and thumb joystick
class InputManager
{   
    public:
    
        /** Creates a new InputManager object
        * @param pinA Pin connected to button A
        * @param pinB Pin connected to button B
        * @param pinc Pin connected to button C
        * @param x Pin connected to the horizontal potentiometer of the joystick
        * @param y Pin connected to the vertical potentiometer of the joystick
        * @param button Pin connected to the button of the thumb joystick
        */
        InputManager(PinName pinA, PinName pinB, PinName pinC, PinName joyH, PinName joyV, PinName joyBtn);
        
        /** Deconstructor. Frees allocated memory related to the buttons and the joystick **/
        ~InputManager();
        
        Joystick *joystick;
        
        /** @brief Adds a button interrupt which is invoked when the button is pressed. Button needs to be released for the interrupt to occur again.
        * @param button Name of the button.
        * @param func Callback function.
        */
        void addBtnPressInterrupt(Input::Button button, void (*func)(void));
        
        
        /** Reads the current value of a button.
        * @param button The button we want to read.
        * @return Returns 1 if button is pressed, 0 otherwise.
        */
        int read(Input::Button button);
    
    private:
        /// Button objects
        PinDetect *btnA;
        PinDetect *btnB;
        PinDetect *btnC;
        
        /** Returns a pointer to the actual button object
        * @param button The requested button.
        * @return Pointer to the button.
        */
        PinDetect* getBtnPtr(Input::Button button);      
};

#endif

