#include "InputManager.h"

/** @file InputManager.cpp
 *  @author Andreas Garmannslund
 *  @date April 2015
*/

InputManager::InputManager(PinName pinA, PinName pinB, PinName pinC, PinName joyH, PinName joyV, PinName joyBtn)
{
    // Init joystick
    joystick = new Joystick(joyH, joyV, joyBtn);
    joystick->calibrate();
    
    // Init buttons
    btnA = new PinDetect(pinA);
    btnB = new PinDetect(pinB);
    btnC = new PinDetect(pinC);
    
    // Default sample frequency
    btnA->setSampleFrequency();
    btnB->setSampleFrequency();
    btnC->setSampleFrequency();
}

InputManager::~InputManager()
{
    delete joystick;
    delete btnA;
    delete btnB;
    delete btnC;
}

void InputManager::addBtnPressInterrupt(Input::Button button, void (*func)(void))
{
    PinDetect *btn = getBtnPtr(button);
    if (btn) // if not null pointer
        btn->attach_asserted(func);
}

PinDetect* InputManager::getBtnPtr(Input::Button button)
{
    switch(button)
    {
        case Input::ButtonA:
            return btnA;
        
        case Input::ButtonB:
            return btnB;
        
        case Input::ButtonC:
            return btnC;
        
        default:
            return 0; // Return 0 (nullptr) if invalid input
    }
}

int InputManager::read(Input::Button button)
{
    PinDetect *btn = getBtnPtr(button);
    if (!btn) return 0; // Invalid button
    
    return *btn; // Value of button
}