#ifndef GAME_H
#define GAME_H

/** @file Game.h
*   @author Andreas Garmannslund
*/

#include "State.h"
#include "Entity.h"
#include "Enemy.h"
#include "map.h"
#include "Geometry.h" // Rectangle and Point structs
#include <vector>
#include <sstream>
#include "Global.h"

#define TERMINAL_VELOCITY 3


/// State: Game
class Game : public State
{
    public:
        /// Creates the Game state
        Game(StateManager* fsm, N5110 *lcd, InputManager* input, Sound *sound)
                : State(fsm, lcd, input, sound) {init();}
                
        /// Deconstructor: Frees all memory that was temporarely allocated by the Game state.
        ~Game();
                                
        /// Handle input and update logic.
        virtual void update(float dt);
        
        /// Draw state to lcd.
        virtual void render();
        
        
    private:
        void init();    // Sets some initial values
        void spawnEnemy();  // Spawns a new enemy
        void moveEnemies(); // Movement and AI for all enemies
        void moveWithCollisionTest(Entity* entity, const int map[HEIGHT][WIDTH]); // Moves entity in map. If collision occurs, entity can not move further.
        bool hitTestRect(Rectangle r1, Rectangle r2); // Returns true if two rectangles overlap @see https://developer.mozilla.org/en-US/docs/Games/Techniques/2D_collision_detection#Axis-Aligned_Bounding_Box
        bool bulletHitMap(Rectangle &bulletColRect, const int map[HEIGHT][WIDTH]); // Help function for detecting collision between moving bullet and map.
        void renderScore(); // Draws the current score in upper right corner
        void respawnPlayer(); // Respawns player at start position
        
        int livesLeft; // The number of lives left
        bool paused;   // True if the game is paused
        
        int spawnRate;  // Probability of enemy spawning in a single frame/update.
        static const int spawnPoints[3][2]; // Positions where enemies can spawn.
        
        Entity player;  // Player object
        std::vector<Point*> bullets;    // Container for bullets
        std::vector<Enemy*> enemies;    // Container for enemies
        
        bool releasedBtnB;  // True if button B has been released after being pressed down
        bool releasedBtnC;  // True if button C has been released after being pressed down
};

#endif
