#ifndef ENTITY_H
#define ENTITY_H
/// @file Entity.h

/** An entity represents a movable character, such as the player, enemies etc.
*   Note that the entity class does not contain the sprite (image) of the entity.
*   Different sprites are given as 2D const int arrays in 
*   OBS! The entity's dimensions should be the same as the width and height or else this will lead to undefined behaviour!
*/
class Entity
{
    public:
        Entity() {x = y = width = height = vx = vy = 0; facingLeft = true; onGround = false; dead = false;}
        Entity(int x, int y, int w = 0, int h = 0) : x(x), y(y), width(w), height(h) {vx = vy = 0; facingLeft = true; onGround = false; dead = false;}
        
        /// Position of entity (origin: left upper corner)
        int x, y;
        
        /// Velocity of entity
        int vx, vy;
        
        /// Width of entity
        int width; 
        
        /// Height of entity     
        int height;
        
        /// True if the entity is facing left
        bool facingLeft; 
        /// True if entity is standing on the ground.
        bool onGround;
        
        /// True if enemy is dead.
        bool dead;
        
        /// Returns x-position of the right edge
        int getRight() {return x + width - 1;}
        
        /// Returns y-position of the bottom edge   
        int getBottom() {return y + height - 1;}
};

#endif