/// @file SubmitHighscore.cpp

#include "SubmitHighscore.h"

int SubmitHighscore::letters[3] = {0, 0, 0};
int SubmitHighscore::currentState = LETTER1;

void SubmitHighscore::init()
{
    input->addBtnPressInterrupt(Input::ButtonA, &btnAPress);
    input->addBtnPressInterrupt(Input::ButtonB, &btnBPress);
    input->addBtnPressInterrupt(Input::ButtonC, &btnCPress);
    
    SubmitHighscore::currentState = LETTER1;
}

void SubmitHighscore::changeLetter(int index, bool next)
{
    int letter = (SubmitHighscore::letters[index] + ((next) ? 1 : - 1) + 26) % 26; // + 26 in case it is negative, % => wrap around from Z->A
    SubmitHighscore::letters[index] = letter;
}

void SubmitHighscore::btnAPress()
{
    switch (currentState)
    {
        case LETTER1:
            changeLetter(0, true);
        break;
        
        case LETTER2:
            changeLetter(1, true);
        break;
        
        case LETTER3:
            changeLetter(2, true);
        break;
        
        case SEL_SUBMIT:
            currentState = WRITE_TO_FILE;
        break;
    }   
}

void SubmitHighscore::btnBPress()
{
    // Change to previous letter
    switch (currentState)
    {
        case LETTER1:
            changeLetter(0, false);
        break;
        
        case LETTER2:
            changeLetter(1, false);
        break;
        
        case LETTER3:
            changeLetter(2, false);
        break;
    }
}

void SubmitHighscore::btnCPress()
{
    switch (currentState)
    {
        case LETTER1:
            currentState = LETTER2;
        break;
        
        case LETTER2:
            currentState = LETTER3;
        break;
        
        case LETTER3:
            currentState = SEL_SUBMIT;
        break;
        
        case SEL_SUBMIT:
            currentState = LETTER1;
        break;
    }
}


void SubmitHighscore::update(float dt)
{
    if (currentState == WRITE_TO_FILE)
    {
        char s0 = 'A' + static_cast<char>(letters[0]);
        char s1 = 'A' + static_cast<char>(letters[1]);
        char s2 = 'A' + static_cast<char>(letters[2]);
        
        std::stringstream ss;
        ss << s0 << s1 << s2;
        
        std::string initials = ss.str();
        
        // update high score list   
        FILE *fp = fopen("/local/highscores.txt", "w");

        if (Global::score > Global::highscores[0].score)
        {
            Global::highscores[2] = Global::highscores[1];
            Global::highscores[1] = Global::highscores[0];
            Global::highscores[0].initials = initials;
            Global::highscores[0].score = Global::score;
        }   
        else if (Global::score > Global::highscores[1].score)
        {
            Global::highscores[2] = Global::highscores[1];
            Global::highscores[1].initials = initials;
            Global::highscores[1].score = Global::score;
        }
        else if (Global::score > Global::highscores[2].score)
        {
            Global::highscores[2].initials = initials;
            Global::highscores[2].score = Global::score;
        }
           
        for (int i = 0; i < 3; ++i)
            fprintf(fp, "%s %d ", Global::highscores[i].initials, Global::highscores[i].score);
                    
        fclose(fp);
        
        currentState = LOAD_GAME_OVER;
    }
    
    if (currentState == LOAD_GAME_OVER)
        requestStateChange(GAME_OVER);
}

void SubmitHighscore::render()
{
    if (currentState == WRITE_TO_FILE)
    {
        lcd->printString("Writing...", 12, 2);
    }
    else // Entering initials
    {           
        lcd->printString("New high score!", 0, 0);
        
        const char charLetters[6] = {'A' + letters[0], '\0', 'A' + letters[1], '\0', 'A' + letters[2], '\0'};
            
        lcd->printString(&charLetters[0], 25, 2);
        lcd->printString(&charLetters[2], 40, 2);
        lcd->printString(&charLetters[4], 55, 2);
        lcd->printString("Submit", 25, 4);
        
        switch(currentState)
        {
            case LETTER1:
                lcd->printString("^", 25, 3);
            break;
            
            case LETTER2:
                lcd->printString("^", 40, 3);
            break;
            
            case LETTER3:
                lcd->printString("^", 55, 3);
            break;
            
            case SEL_SUBMIT:
                lcd->printString(">",25-6 , 4);
            break;
        }
    }   
}