#ifndef ENEMY_H
#define ENEMY_H

/// @file Entity.h

#include "Entity.h"

/// Enemy class
class Enemy : public Entity
{
    public:
        /// Different type of enemies
        enum Type{SIMPLE, JUMPER, RUNNER};
    
    public:
        Enemy(int x, int y, bool facingLeft, Type type = SIMPLE) : Entity(x,y), type(type) {setup();}
        
        /// What type of enemy it is.
        Type type;      
        
        /// Multiplier used for giving more points
        int difficulty; 
        
        /// Probability (in percent) of trying to jump if at ground.
        int jumpRate;
        
        private:
            void setup();
};
#endif