#ifndef TITLE_SCREEN_H
#define TITLE_SCREEN_H

#include "State.h"

/// @file TitleScreen.h

/// Used to display the splash screen which is shown when turning the device on.
class TitleScreen : public State
{
    public:
        TitleScreen(StateManager* fsm, N5110 *lcd, InputManager* input, Sound* sound)
                : State(fsm, lcd, input, sound) {init();}
        
        virtual void update(float dt);
        virtual void render();
        
    private:
        void init();
        static void btnPress();
        static const int splashScreen[48][84];
        static bool btnWasPressed;
        
};

#endif