#ifndef SOUND_H
#define SOUND_H

/// @file Sound.h

#include "mbed.h"
#include "Resources.h"

/// A note is given by its frequency and beat.
struct Note
{
    Note(float f, float b = 1.0) : frequency(f), beat(b) {}
    float frequency;    /// Frequency of note
    float beat;         /// Normal beat last for 1 cycle
};

/// Sound uses a piezo buzzer connect to a PWMOut to output sound
class Sound
{
    public:
        /* Creates a new sound object.
         * @param pin The pin of the pwm output the piezo buzzer is connected to.
        */
        Sound(PinName buzzerPin);
        
        /// Destructor
        ~Sound(); 
        
        /// Plays the given note. @param note The note to be played.
        void playNote(Note &note);
        
    private:
        void start() {*buzzer = 0.5;}   // Set duty cycle to 50%
        void stop() {*buzzer = 0.0;}    // Turn off pwm out
    
    // Variables
    private:
        PwmOut *buzzer; // Piezo buzzer.
        Timeout ticker; // Used for stopping sound after the given beat.
};

/// Sound effects. Commonly used notes.
namespace SFX
{
    extern Note PLAYER_DEAD;
    extern Note ENEMY_DEAD;
    extern Note BULLET_FIRED;
    extern Note PLAYER_JUMP;
    extern Note RESTART;
}

#endif