#ifndef MOTORCONTROLLER_H
#define MOTORCONTROLLER_H

#include "mbed.h"
#include "HBridge.h"

class MotorController {
    public:
        MotorController (HBridge &motor, AnalogIn &motorInput);
        
        void start ();
        void stop ();
        
        void turnLeft ();
        void turnRight ();
        void setPosition (float position);
        
        float getPosition ();
        
        static const float POSITION_0  = 0.5f;
        static const float POSITION_1  = 1.2f;
        static const float POSITION_2  = 3.6f;
        static const float POSITION_3  = 9.7f;
        static const float POSITION_4  = 17.5f;
        static const float POSITION_5  = 25.0f;
        static const float POSITION_6  = 33.0f;
        static const float POSITION_7  = 47.7f;
        static const float POSITION_8  = 80.0f;
        static const float POSITION_9  = 100.0f;
        static const float POSITION_10 = 100.0f;
    
    private:
        HBridge &motor;
        AnalogIn &motorInput;
};

#endif