#include "MotorController.h"

MotorController::MotorController (HBridge &motor, AnalogIn &motorInput) :
    motor ( motor ), motorInput ( motorInput ) {
}

void MotorController::start () {
    this->motor.start();
}

void MotorController::stop () {
    this->motor.stop();
}

void MotorController::turnLeft () {
    this->motor.start();
    this->motor.backward();
}


void MotorController::turnRight () {
    this->motor.start();
    this->motor.forward();
}

void MotorController::setPosition (float position) {
    float current_position = this->getPosition();
    
    if (current_position > position) {
        this->turnLeft();
        
        while (1) {
            if (this->getPosition() <= position) {
                this->stop();
                break;
            }
        }
    }
    else {
        this->turnRight();
        
        while (1) {
            if (this->getPosition() >= position) {
                this->stop();
                break;
            }
        }
    }
}


float MotorController::getPosition () {
    return this->motorInput.read() * 100.0f;
}