#include "PcControls.h"

MotorControlsPc::MotorControlsPc(MotorController &motorController) : 
    motorController ( motorController ) {
}

MotorController MotorControlsPc::getMotorController () {
    return this->motorController;
}

void MotorControlsPc::ProcessPcInput(char c) {
    switch (c) {
        case MOTOR_FORWARD:
            this->motorController.turnRight();
            break;
        case MOTOR_BACKWARD:
            this->motorController.turnLeft();
            break;
        case MOTOR_POSITION:
            printf("Motor position: %3.3f%% \r\n", this->motorController.getPosition());
            // Return immediately to prevent the servo regulating system from
            // seeing MOTOR_POSITION as the command that is has to keep regulating.
            return;
        case MOTOR_START:
            this->motorController.start();
            break;
        case MOTOR_POSITION_0:
            this->motorController.setPosition(MotorController::POSITION_0);
            break;
        case MOTOR_POSITION_1:
            this->motorController.setPosition(MotorController::POSITION_1);
            break;
        case MOTOR_POSITION_2:
            this->motorController.setPosition(MotorController::POSITION_2);
            break;
        case MOTOR_POSITION_3:
            this->motorController.setPosition(MotorController::POSITION_3);
            break;
        case MOTOR_POSITION_4:
            this->motorController.setPosition(MotorController::POSITION_4);
            break;
        case MOTOR_POSITION_5:
            this->motorController.setPosition(MotorController::POSITION_5);
            break;
        case MOTOR_POSITION_6:
            this->motorController.setPosition(MotorController::POSITION_6);
            break;
        case MOTOR_POSITION_7:
            this->motorController.setPosition(MotorController::POSITION_7);
            break;
        case MOTOR_POSITION_8:
            this->motorController.setPosition(MotorController::POSITION_8);
            break;
        case MOTOR_POSITION_9:
            this->motorController.setPosition(MotorController::POSITION_9);
            break;
        case MOTOR_POSITION_10:
            this->motorController.setPosition(MotorController::POSITION_10);
            break;
        case MOTOR_HALT:
            this->motorController.stop();
            break;          
    }
    
    this->motorController.setCurrentAction(c);
}
