#include "mbed.h"
#include "HTS221Sensor.h"

Serial pc(SERIAL_TX, SERIAL_RX);


DigitalOut myled(LED1);
DigitalOut led(LED1);

DevI2C devi2c(I2C_SDA, I2C_SCL);

HTS221Sensor hts221(&devi2c);


int main()
{
    float hum = 0;
    float temp = 0;
    pc.baud(9600);
    pc.printf("Hello World !\n");



    HTS221_Init_st init_st;
    init_st.avg_h = HTS221_AVGH_4;
    init_st.avg_t = HTS221_AVGT_4;
    init_st.odr = HTS221_ODR_1HZ;
    init_st.bdu_status = HTS221_ENABLE;
    init_st.heater_status = HTS221_ENABLE;
    init_st.irq_level = HTS221_HIGH_LVL;
    init_st.irq_output_type = HTS221_PUSHPULL;
    init_st.irq_enable = HTS221_DISABLE;

    int ret =  hts221.init(&init_st);

    if(ret ==0) {
        pc.printf("init succesed!");
    }


    hts221.enable();
    while(1) {

        hts221.get_humidity(&hum);
        hts221.get_temperature(&temp);
        
        pc.printf("hum:%f temp:%f\r\n",hum,temp);
        wait(1);
    }

}
