#include "mbed.h"
#include "HTS221_driver.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/

//https://www.cnblogs.com/zlbg/p/4216251.html

DigitalOut myled(LED1);
DigitalOut led(LED1);

I2C i2c(I2C_SDA, I2C_SCL);
HTS221Sensor hts221;
char data_write[2];
char data_read[4];


float t0, t1, h0, h1;
int t0out, t1out, h0out, h1out;

int16_t outHumi = 0;
int16_t outTemp = 0;

float valueHumi = 0;
float valueTemp = 0;



float mapFloat(int x, int in_min, int in_max, float out_min, float out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


void read_calidata0()
{

//Read Cali Data

    //read out t0degCx8, t1degCx8
    data_write[0] = HTS221_T0_DEGC_X8;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 4, 0);




    int t0degCx8 = ((data_read[3] & 0b00000011) << 8) | data_read[0];
    int t1degCx8 = ((data_read[3] & 0b00001100) << 6) | data_read[1];
    t0 = t0degCx8/8.0;
    t1 = t1degCx8/8.0;

    //read out t0out, t1out

    data_write[0] = HTS221_T0_OUT_L |0x80;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 4, 0);

    t0out = (data_read[1] << 8) | data_read[0];
    t1out = (data_read[3] << 8) | data_read[2];


    //read out h0RHx2, h1RHx2
    data_write[0] = HTS221_H0_RH_X2 |0x80;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 2, 0);

    unsigned char h0RHx2  =  data_read[0];
    unsigned char h1RHx2  =  data_read[1];

    h0 = h0RHx2/2.0;
    h1 = h1RHx2/2.0;

    //read out h0t0Out

    data_write[0] = HTS221_H0_T0_OUT_L |0x80;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 2, 0);

    h0out   =  (data_read[1] << 8) | data_read[0];


    //read out h1t0Out
    data_write[0] = HTS221_H1_T0_OUT_L |0x80;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 2, 0);

    h1out   =  (data_read[1] << 8) | data_read[0];

    //print the calibration coefficients
    printf("Calibration coefficients: \r\n");
    printf("t0 =%f `C t0out = %d \r\n",t0,t0out);
    printf("t1 =%f `C t1out = %d \r\n",t1,t1out);
    printf("h0 =%f RH h0out = %d \r\n",h0,h0out);
    printf("h1 =%f RH h1out = %d \r\n",h1,h1out);
    printf("------------------------\r\n");

}

HTS221_Error_et HTS221_Get_Temperature1(int16_t *value)
{
    int16_t T0_out,T1_out,T_out,T0_degC_x8_u16,T1_degC_x8_u16;
    int16_t T0_degC, T1_degC;
    uint8_t buffer[4], tmp;
    uint32_t tmp32;

    /*1. Read from 0x32 & 0x33 registers the value of coefficients T0_d egC_x8 and T1_de gC_x8*/
    data_write[0] = HTS221_T0_DEGC_X8;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,(char*)buffer, 2, 0);

    /*2. Read from 0x35 register the value of the MSB bits of T1_deg C and T0_deg C */
    data_write[0] = HTS221_T0_T1_DEGC_H2;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,(char*)&tmp, 1, 0);

    /*Calculate the T0_deg C and T1_deg C values*/

    T0_degC_x8_u16 = (((uint16_t)(tmp & 0x03)) << 8) | ((uint16_t)buffer[0]);
    T1_degC_x8_u16 = (((uint16_t)(tmp & 0x0C)) << 6) | ((uint16_t)buffer[1]);
    T0_degC = T0_degC_x8_u16>>3;
    T1_degC = T1_degC_x8_u16>>3;

    /*3. Read from 0x3C & 0x3D registers the value of T0_OUT*/
    /*4. Read from 0x3E & 0x3F registers the value of T1_OUT*/

    data_write[0] = HTS221_T0_OUT_L |0x80;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,(char*)buffer, 4, 0);

    T0_out = (((uint16_t)buffer[1])<<8) | (uint16_t)buffer[0];
    T1_out = (((uint16_t)buffer[3])<<8) | (uint16_t)buffer[2];

    /* 5.Read from 0x2A & 0x2B registers the value T_OUT (ADC _OUT).*/

    data_write[0] = HTS221_TEMP_OUT_L_REG;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,(char*)buffer, 2, 0);

    T_out = (((uint16_t)buffer[1])<<8) | (uint16_t)buffer[0];

    /* 6. Compute the Temperature value by linea r interpolation*/
    tmp32 = ((uint32_t)(T_out - T0_out)) * ((uint32_t)(T1_degC - T0_degC)*10);
    *value = tmp32 /(T1_out - T0_out) + T0_degC*10;

    return HTS221_OK;


}

int main()
{
    HTS221_Error_et ret;
    uint8_t deviceid;
    
    HTS221_Get_DeviceID(&deviceid);

    HTS221_Init_st init_st;
    init_st.avg_h = HTS221_AVGH_4;
    init_st.avg_t = HTS221_AVGT_4;
    init_st.odr = HTS221_ODR_1HZ;
    init_st.bdu_status = HTS221_ENABLE;
    init_st.heater_status = HTS221_ENABLE;
    init_st.irq_level = HTS221_HIGH_LVL;
    init_st.irq_output_type = HTS221_PUSHPULL;
    init_st.irq_enable = HTS221_DISABLE;

    HTS221_Set_InitConfig(&init_st);



    if(deviceid != HTS221_WHO_AM_I_VAL) {
        printf("HTS221 Not Found!\r\n");
        while(1) {
            myled=!myled;
            wait(0.2);
        }
    } else {
        printf("HTS221 Has Found!\r\n");
    }

    HTS221_Activate();



    HTS221_BitStatus_et mode;
    HTS221_Get_PowerDownMode(&mode);
    if(mode == HTS221_SET) {
        printf("HTS221 in power down mode\r\n");

        ret = HTS221_Set_PowerDownMode(HTS221_RESET);
        if(ret != HTS221_OK) {
            printf("HTS221_Set_PowerDownMode failed");
        }
    }
    HTS221_Get_PowerDownMode(&mode);
    if(mode == HTS221_SET) {
        printf("HTS221 in power down mode\r\n");

        ret = HTS221_Set_PowerDownMode(HTS221_RESET);
        if(ret != HTS221_OK) {
            printf("HTS221_Set_PowerDownMode failed");
        }
    }

    HTS221_Set_BduMode(HTS221_DISABLE);

    uint16_t humidity;
    int16_t temperature;
    uint16_t humi;
    int16_t temp;
    int16_t temp2;



    HTS221_DrdyLevel_et level = HTS221_LOW_LVL ;

    printf("pre level=%02x\r\n",level);

    HTS221_Set_IrqActiveLevel(HTS221_HIGH_LVL);


    HTS221_Get_IrqActiveLevel(&level);

    printf("aft level=%d\r\n",level);


    //  while(1) {
//    HTS221_StartOneShotMeasurement();
//
//    ret = HTS221_Get_Measurement(&humidity,&temperature);
//    if(ret==HTS221_OK){
//        printf("humidity:%d%%,temperature:%dC\r\n",humidity/10,temperature/10);
//    }else
//    {
//        printf("GET Measurement failed\r\n");
//    }
//    ret = HTS221_Get_Humidity(&humi);
//      if(ret==HTS221_OK){
//        printf("humi:%d\r\n",humi);
//    }else
//    {
//        printf("GET humi failed\r\n");
//    }
//
//    ret = HTS221_Get_Temperature(&temp);
//    if(ret==HTS221_OK){
//        printf("temp:%d\r\n",temp);
//    }else
//    {
//        printf("GET temp failed\r\n");
//    }
//
//
//
//     ret = HTS221_Get_Temperature1(&temp2);
//
//    if(ret==HTS221_OK){
//        printf("temp2:%d\r\n",temp2);
//    }else
//    {
//        printf("GET temp2 failed\r\n");
//    }
//
//
//    wait(1);
//    }



    //Find the HTS221
    data_write[0] = HTS221_WHO_AM_I_REG;
    i2c.write(0xBE, data_write, 1, 1);
    i2c.read(0xBF,data_read, 1, 0);


    //turn on the HTS221, set the update mode to one shot
    data_write[0] = HTS221_CTRL_REG1;
    data_write[1] = 0x84;
    int status = i2c.write(0xBE, data_write, 2, 0);
    if(status!=0) {
        while(1) {
            myled=!myled;
            wait(0.2);
        }
    }

    read_calidata0();


    while(1) {
        //perform a measurement
        data_write[0] = HTS221_CTRL_REG2;
        data_write[1] = 0x01;
        i2c.write(0xBE, data_write, 2, 0);
        //check the status
        status = 0;
        while (status != 0x03) { //typical conversition time: 3ms


            wait(0.3);
            data_write[0] = HTS221_STATUS_REG;
            i2c.write(0xBE, data_write, 1, 0);
            i2c.read(0xBF,data_read, 1, 0);
            status = data_read[0];

            wait(0.1);
//            printf("status:%d\r\n",status);
        }

        //read multiple bytes incrementing the register address

        data_write[0] = HTS221_HR_OUT_L_REG |0x80;
        i2c.write(0xBE, data_write, 1, 1);
        i2c.read(0xBF,data_read, 4, 0);

        outHumi = (data_read[1] << 8) | data_read[0];
        outTemp = (data_read[3] << 8) | data_read[2];

        valueTemp = mapFloat(outTemp, t0out, t1out, t0, t1);
        valueHumi = mapFloat(outHumi, h0out, h1out, h0, h1);

        printf("Temp:%f `C Humi:%f RH \r\n",valueTemp,valueHumi);



        led = !led; // Toggle LED
        wait(3); // 1 second
    }
}
