#include "mbed.h"

#define TEMP130_CAL_ADDR ((uint16_t*) ((uint32_t) 0x1FF8007E))
#define TEMP30_CAL_ADDR ((uint16_t*) ((uint32_t) 0x1FF8007A))
#define VDD_CALIB ((uint16_t) (300))
#define VDD_APPLI ((uint16_t) (330))
Serial pcMain(USBTX, USBRX);


int32_t ComputeTemperature(uint32_t measure)
{
  int32_t temperature;
  temperature = ((measure * VDD_APPLI / VDD_CALIB) - (int32_t)*TEMP30_CAL_ADDR );
  temperature = temperature *(int32_t)(130-30);
  temperature = temperature /(int32_t)(*TEMP130_CAL_ADDR -*TEMP30_CAL_ADDR);
  temperature = temperature + 30;
  return(temperature);
}


void ConfigTemperature(void){
    //Clock configuration
    RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
    ADC1->CFGR2 |= ADC_CFGR2_CKMODE;

    //*******************//NEW PART BEGIN//******************//
    //ADC Calibration
    if ((ADC1->CR & ADC_CR_ADEN) != 0) /* (1) */
    {
     ADC1->CR &= (uint32_t)(~ADC_CR_ADEN); /* (2) */
    }
    ADC1->CR |= ADC_CR_ADCAL; /* (3) */
    while ((ADC1->ISR & ADC_ISR_EOCAL) == 0) /* (4) */
    {
        pcMain.printf("Calib");
    }
    ADC1->ISR |= ADC_ISR_EOCAL;
    
    //Enable the ADC
    ADC1->ISR |= ADC_ISR_ADRDY; /* (1) */
    ADC1->CR |= ADC_CR_ADEN; /* (2) */
    if ((ADC1->CFGR1 & ADC_CFGR1_AUTOFF) == 0)
    {
     while ((ADC1->ISR & ADC_ISR_ADRDY) == 0) /* (3) */
     {
         pcMain.printf("Enable");
     }
    }
    //*******************//NEW PART END//******************//

    //Configuration of the temp sensor
    ADC1->CFGR1 |= ADC_CFGR1_CONT; /* (2) */
    ADC1->CHSELR = ADC_CHSELR_CHSEL18; /* (3) */
    ADC1->SMPR |= ADC_SMPR_SMP; /* (4) */
    wait(1);
    ADC->CCR |= ADC_CCR_TSEN;
    wait(1);
    uint32_t measure = ADC1->DR;
    pcMain.printf("Measure %u\n\r", measure);
    pcMain.printf("The temperature value is %i\n\r",ComputeTemperature(measure));

}

/***************************************************************************//**
 * @fn main(void)
 * @brief Main of the project
 * @param void
 * @return int
 * @author Edson CALSIN, Francois DREVETON, Simon NOWAK
 *
 ******************************************************************************/
int main(void)
{
    ConfigTemperature();
}
