/*
Fachhochschule Bingen
Projekt: Video-Downlink für die Flugdrohne "BIRD"
Programmname: F411_spi_master
Header-Datei osd.h
Datenübertragung zwischen STM32F411RE Nucleo und Maxim MAX7456 OSD
Stand: 29.08.2015
*/
#include "mbed.h"
typedef unsigned char byte;
#define VM0 0x00
#define DMM 0x04
#define DMAH 0x05
#define DMAL 0x06
#define DMDI 0x07
#define OSDBL 0x6C
SPI osd(PB_5, PB_4, PB_3); //MOSI, MISO, SCK SPI3
DigitalOut cs(PA_10); // Chip Select SPI3

//DigitalOut pinReset(

byte abData[35]={0}; // Array for data to be written to osd
/* initialize OSD */
void fInitosd(void){
    osd.format(8,3);
    //osd.frequency(1000000);
    wait(0.1);
    cs=0; // Start transmission
    osd.write(OSDBL); // Automatic Black Level Correction
    osd.write(0x00);
    cs=1; // End transmission
    wait_us(50);
    cs=0;
    osd.write(VM0); // Set VM0 to PAL and enable OSD image
    osd.write(0x48);
    cs=1;
    wait_us(50);
    }

/* Set position on display */
byte fbSet_pos(byte bHipos, byte bLopos){
    cs=0;
    osd.write(DMAH); // DMAH to address value
    osd.write(bHipos);
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(DMAL); // Set character start location on display
    osd.write(bLopos);
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(DMM); //Set auto-increment mode
    osd.write(0x01);
    cs=1;
    wait_us(50);
    return 0;
    }
/* write altitude to screen */
void fWrite_altitude(void){
    byte bCount;
    abData[0]=0x09;
    abData[1]=0x09;
    abData[2]=0x09;
    
    cs=0; // Symbol
    osd.write(0x50);
    cs=1;
    cs=0; // Space
    osd.write(0x00);
    cs=1;
    wait_us(50);
    
    for(bCount=0; bCount<3; bCount++){
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
    
    cs=0;
    osd.write(0x31); // character 'm' for meters
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0xFF); // end of auto-increment
    cs=1;
    wait_us(50);
    }
    
/* write velocity to screen */
void fWrite_velocity(void){
    byte bCount; // counter variable
    abData[3]=0x09;
    abData[4]=0x09;
    cs=0; // Symbol
    osd.write(0x51);
    cs=1;
    cs=0; // Space
    osd.write(0x00);
    cs=1;
    cs=0; // Space
    osd.write(0x00);
    cs=1;
    wait_us(50);
    for(bCount=3; bCount<5; bCount++){
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
    cs=0; // Symbol
    osd.write(0x55);
    cs=1;
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
    
/* write camera mode to screen */
void fWrite_cammode(void){
    byte bCount; // counter variable
    abData[5]=0x01;
    abData[6]=0x07;
    abData[7]=0x03;
    cs=0; // Symbol Camera
    osd.write(0x54);
    cs=1;
    wait_us(50);
    for(bCount=5; bCount<8; bCount++){
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
    
/* write voltage of video system battery to screen*/
void fWrite_vol_Vid(void){
    byte bCount; // counter variable
    abData[8]=0x01;
    abData[9]=0x01;
    abData[10]=0x01;
    cs=0; // Symbol video battery
    osd.write(0x56);
    cs=1;
    wait_us(50);
    
    for(bCount=8; bCount<10; bCount++){ // write first two digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0; // write '.'
    osd.write(0x41);
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(abData[10]); // write third digit
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0x20); // set character 'V' for voltage
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
    
/* write voltage of engine battery to screen*/
void fWrite_vol_Eng(void){
    byte bCount; // counter variable
    abData[11]=0x01;
    abData[12]=0x01;
    abData[13]=0x01;
    cs=0; // Symbol engine battery
    osd.write(0x57);
    cs=1;
    wait_us(50);
    
    for(bCount=11; bCount<13; bCount++){ // write first two digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
    
    cs=0; // write '.'
    osd.write(0x41);
    cs=1;
    wait_us(50);
    cs=0; // write third digit
    osd.write(abData[13]);
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0x20); // set character 'V' for voltage
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
    
/* write gps longitude to screen */
void fWrite_lon(void){
    byte bCount; // counter variable
    abData[14]=0x09;
    abData[15]=0x09;
    abData[16]=0x09;
    abData[17]=0x09;
    abData[18]=0x09;
    abData[19]=0x09;
    abData[20]=0x09;
    abData[21]=0x09;
    cs=0; // Symbol longitude
    osd.write(0x53);
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0x00);
    cs=1;
    wait_us(50);
    
    for(bCount=14; bCount<16; bCount++){ // write first two digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0; // write '.'
    osd.write(0x41);
    cs=1;
    wait_us(50);
    
    for(bCount=16; bCount<22; bCount++){ // write last six digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
    
/* write gps latitude to screen */
void fWrite_lat(void){
    byte bCount; // counter variable
    abData[22]=0x09;
    abData[23]=0x09;
    abData[24]=0x09;
    abData[25]=0x09;
    abData[26]=0x09;
    abData[27]=0x09;
    abData[28]=0x09;
    abData[29]=0x09;
    abData[30]=0x09;
    cs=0; // Symbol latitude
    osd.write(0x52);
    cs=1;
    wait_us(50);
    
    for(bCount=22; bCount<25; bCount++){ // write first three digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0; // write '.'
    osd.write(0x41);
    cs=1;
    wait_us(50);
    
    for(bCount=25; bCount<31; bCount++){ // write last six digits
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0;
    osd.write(0xFF);
    cs=1;
    wait_us(50);
    }
/* write distance to home position to screen */
void fWrite_home(void){
    byte bCount;
    abData[31]=0x09;
    abData[32]=0x09;
    abData[33]=0x09;
    abData[34]=0x09;
    cs=0; // Symbol home
    osd.write(0x58);
    cs=1;
    wait_us(50);
    
    for(bCount=30; bCount<34; bCount++){
        cs=0;
        osd.write(abData[bCount]);
        cs=1;
        wait_us(50);
        }
        
    cs=0;
    osd.write(0x31); // character 'm' for meters
    cs=1;
    wait_us(50);
    cs=0;
    osd.write(0xFF); // end of auto-increment
    cs=1;
    wait_us(50);
    }