// AD-12864-SPI test program
// About AD-12864-SPI, see http://www.aitendo.co.jp/product/1622.

// Pin allocation
// 1 p21 #CS1 with 10k ohm pull-up
// 2 p22 #RESET with 10k ohm pull-up
// 3 p23 A0 ... 0:command 1:data
// 4 p13 SCK
// 5 p11 MOSI
// 6     Vdd
// 7     Vss
// 8 NC  LED_A 

#include "mbed.h"

DigitalOut cs(p21);
DigitalOut rst(p22);
DigitalOut a0(p23);
SPI spi(p11, p12, p13); // mosi, miso, sclk

void regwrite(unsigned char c){
    cs = a0 = 0;
    spi.write(c);
    cs = 1;
}

void datawrite(unsigned char c){
    cs = 0;
    a0 = 1;
    spi.write(c);
    cs = 1;
}

// set position (x, 8*y)
void locate(int x, int y){
    regwrite(0xb0 | (y & 0x0f)); // Page Address Set (see 2.4.3)
    regwrite(0x10 | (x >> 4 & 0x0f)); // Column Address Set (see 2.4.4)
    regwrite(x & 0x0f);
}

void cls(void){
    int x, y;
    for(y = 0; y < 8; y++){
        locate(0, y);
        for(x = 0; x < 128; x++) datawrite(0x00);
    }
}

void plot(int x, int y){
    locate(x, y >> 3);
    datawrite(1 << (y & 7));
}

void init(){
    spi.format(8,0); // nazo
    spi.frequency(20000000); // modify later
    
    // reset
    wait_ms(200);
    rst = 0;
    wait_ms(200);
    rst = 1;

    // initialize sequence
    regwrite(0xaf);    // display on (see 2.4.1)
    regwrite(0x2f);    // power control set (see 2.4.16)
    regwrite(0x81);    // set electronic volume mode (see 2.4.18)
//    regwrite(0x1f);    // electronic volume data 00-3f
    regwrite(0x00);    // electronic volume data 00-3f
    regwrite(0x27);    // V5 Volatge Regulator Internal Resister Ratio Set (see 2.4.17)
    regwrite(0xa2);    // LCD Bias Set ... 1/9 bias (see 2.4.11)
    regwrite(0xc8);    // Common Output Mode Select ... Reverse (see 2.4.15)
    regwrite(0xa0);    // ADC Select ... Normal (see 2.4.8)
    regwrite(0xa4);    // Display All Points ON/OFF ... normal (see 2.4.10)
    regwrite(0xa6);    // Display Normal/Reverse ... normal (see 2.4.9)
    regwrite(0xac);    // Static Indicator ... off (see 2.4.19)
    regwrite(0x00);    // off
    regwrite(0x40);    // Display Strat Line Set ... 0 (see 2.4.2)
    regwrite(0xe0);    // Write Mode Set
}

DigitalOut myled(LED1);

int main() {
    int i;

    init();

    cls();
    locate(0, 0);
    for(i = 0; i < 256; i++) datawrite(i);

    for(i = 0; i < 64; i++){
        plot(64 + i, 0);
        plot(64 + i, 63);
    }

    for(i = 0; i < 8; i++){
        locate(64, i);
        datawrite(0xff);
        locate(127,i);
        datawrite(0xff);
    }

    for(i = 0; i < 64; i++) plot(i, i);

    while(1) {
        myled = 1;
        wait_ms(200);
        myled = 0;
        wait_ms(200);
    }
}
