// AD-12684-SPI control class
// version 0.1
// created by Sim (http://mbed.org/users/Sim/)
//
// About AD-12864-SPI, see http://www.aitendo.co.jp/product/1622 .

#ifndef __SPILCD_H__
#define __SPILCD_H__

#include "mbed.h"

class SPILCD {
private:
    DigitalOut cs, rst, a0;
    SPI spi;

    // boot up sequence
    void init(){
        spi.format(8,0); // nazo
        spi.frequency(20000000); // modify later
        
        // reset
        wait_ms(200);
        rst = 0;
        wait_ms(200);
        rst = 1;
    
        // initialize sequence
        regwrite(0xaf);    // display on (see 2.4.1)
        regwrite(0x2f);    // power control set (see 2.4.16)
        regwrite(0x81);    // set electronic volume mode (see 2.4.18)
//        regwrite(0x1f);    // electronic volume data 00-3f
        regwrite(0x00);    // electronic volume data 00-3f ... control your own value
        regwrite(0x27);    // V5 Volatge Regulator Internal Resister Ratio Set (see 2.4.17)
        regwrite(0xa2);    // LCD Bias Set ... 1/9 bias (see 2.4.11)
        regwrite(0xc8);    // Common Output Mode Select ... Reverse (see 2.4.15)
        regwrite(0xa0);    // ADC Select ... Normal (see 2.4.8)
        regwrite(0xa4);    // Display All Points ON/OFF ... normal (see 2.4.10)
        regwrite(0xa6);    // Display Normal/Reverse ... normal (see 2.4.9)
        regwrite(0xac);    // Static Indicator ... off (see 2.4.19)
        regwrite(0x00);    // off
        regwrite(0x40);    // Display Strat Line Set ... 0 (see 2.4.2)
        regwrite(0xe0);    // Write Mode Set
    }

    // write command
    void regwrite(unsigned char c){
        cs = a0 = 0;
        spi.write(c);
        cs = 1;
    }
    
public:

    // constructor
    SPILCD(PinName cs_pin, PinName rst_pin, PinName a0_pin, PinName mosi_pin, PinName miso_pin, PinName sclk_pin)
        : cs(cs_pin), rst(rst_pin), a0(a0_pin), spi(mosi_pin, miso_pin, sclk_pin) {
        
        init();
        cls();
    }

    // wipe all screen
    void cls(void){
        int x, y;
        for(y = 0; y < 8; y++){
            locate(0, y);
            for(x = 0; x < 128; x++) write(0x00);
        }
    }

    // move position to (x, 8 * y)
    void locate(int x, int y){
        regwrite(0xb0 | (y & 0x0f)); // Page Address Set (see 2.4.3)
        regwrite(0x10 | (x >> 4 & 0x0f)); // Column Address Set (see 2.4.4)
        regwrite(x & 0x0f);
    }

    // write data
    void write(unsigned char c){
        cs = 0;
        a0 = 1;
        spi.write(c);
        cs = 1;
    }

};

#endif
