#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void ledout(int pat) {
    led1 = pat & 1;
    led2 = pat >> 1 & 1;
    led3 = pat >> 2 & 1;
    led4 = pat >> 3 & 1;
}

int main() {
    int i;

    while (1) {
        // move left
        for (i = 0x01; i != 0x8; i <<= 1) {
            ledout(i);
            wait(0.2);
        }
        // move right
        for (i = 0x08; i != 1; i >>= 1) {
            ledout(i);
            wait(0.2);
        }
    }
}
