// AD-12684-SPI control class
// version 0.1
// created by Sim (http://mbed.org/users/Sim/)
//
// About AD-12864-SPI, see http://www.aitendo.co.jp/product/1622 .

#ifndef __SPILCD_H__
#define __SPILCD_H__

#include "mbed.h"

class SPILCD {
private:
    DigitalOut cs, rst, a0;
    SPI spi;

    // boot up sequence
    void init(){
        spi.format(8,0); // nazo
        spi.frequency(20000000); // modify later
        
        // reset
        wait_ms(10);
        rst = 0;
        wait_us(1);
        rst = 1;
        wait_us(1);
    
        // initialize sequence
        cmd(0xa2);    // (11) LCD Bias Set ... 1/9 bias (see 2.4.11)
        cmd(0xa0);    // (8)  ADC Select ... normal (see 2.4.8)
        cmd(0xc8);    // (15) Common Output Mode Select ... Reverse (see 2.4.15)
        cmd(0x24);    // (17) V5 Volatge Regulator Internal Resister Ratio Set (see 2.4.17)
        cmd(0x81);    // (18) set electronic volume mode (see 2.4.18)
        cmd(0x1e);    //      electronic volume data 00-3f ... control your own value
        cmd(0x2f);    // (16) power control set (see 2.4.16)
        cmd(0x40);    // (2)  Display Start Line Set ... 0 (see 2.4.2)
        cmd(0xe0);    // (6)  Write Mode Set
        cmd(0xaf);    // (1)  display on (see 2.4.1)
    }

public:

    // constructor
    SPILCD(PinName cs_pin, PinName rst_pin, PinName a0_pin, PinName mosi_pin, PinName miso_pin, PinName sclk_pin)
        : cs(cs_pin), rst(rst_pin), a0(a0_pin), spi(mosi_pin, miso_pin, sclk_pin) {
        
        init();
        cls();
    }

    // wipe all screen
    void cls(void){
        int x, y;
        for(y = 0; y < 8; y++){
            moveto(0, y);
            for(x = 0; x < 128; x++) write(0x00);
        }
        moveto(0, 0);
    }

    // move position to (x, 8 * y)
    void moveto(int x, int y){
        cmd(0xb0 | (y & 0x0f)); // Page Address Set (see 2.4.3)
        cmd(0x10 | (x >> 4 & 0x0f)); // Column Address Set (see 2.4.4)
        cmd(x & 0x0f);
    }

    // write command
    void cmd(unsigned char c){
        cs = a0 = 0;
        spi.write(c);
        cs = 1;
    }
    
    // write data
    void write(unsigned char c){
        cs = 0;
        a0 = 1;
        spi.write(c);
        cs = 1;
    }
};

#endif
