#include "mbed.h"
#include "spilcd.h"
#include "kfont8.h"

#define countof(x) ( sizeof(x) / sizeof(x[0]) )

SPILCD lcd(p21, p22, p23, p11, p12, p13);

int csrx = 0;
int csry = 0;
int offsety = 0;
bool kstate = false;
unsigned char kbuf;

void locate(int x, int y){
    csrx = x;
    csry = y;
    if(csrx < 0) csrx = 0;
    if(csry < 0) csry = 0;
    csrx &= 31;
    csry &= 7;
    lcd.moveto(csrx << 3, (offsety + csry) & 7);
};

void scroll(void){
    int i;
    offsety = (offsety + 1) & 7;
    lcd.cmd(0x40 | offsety << 3);
    lcd.moveto(0, (offsety + 7) & 7);
    for(i = 0; i < 128; i++) lcd.write(0);
}

void newline(void){
    csrx = 0;
    if(++csry == 8){
        scroll();
        csry = 7;
    }
    locate(csrx, csry);
}

// draw 4x8 font
void drawfont4(unsigned char c){
    const unsigned char *p = &font4[c << 2];
    lcd.write(p[0]);
    lcd.write(p[1]);
    lcd.write(p[2]);
    lcd.write(p[3]);
    // cursor control
    if(++csrx == 32) newline();
}

const unsigned char *findface(unsigned short c){
    const unsigned char *p = NULL;
    int i, sum;
    for(sum = i = 0; i < countof(font8table); i++){
        if(font8table[i].start <= c && c <= font8table[i].end){
            p = &font8[(sum + c - font8table[i].start) << 3];
            break;
        }
        sum += font8table[i].end - font8table[i].start + 1;
    }
    return p;
}

// draw 8x8 font
void drawkanji(unsigned short c){
    const unsigned char *p = findface(c);
    if(p == NULL) return;

    if(csrx >= 31) newline();
    lcd.write(p[0]);
    lcd.write(p[1]);
    lcd.write(p[2]);
    lcd.write(p[3]);
    lcd.write(p[4]);
    lcd.write(p[5]);
    lcd.write(p[6]);
    lcd.write(p[7]);
    csrx += 2;
    if(csrx == 32) newline();
}

void drawc(unsigned char c){
    if(kstate){ // 2nd byte of shift-jis
        kstate = false;
        drawkanji(kbuf << 8 | c);
    } else if((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)){ // 1st byte of shift-jis
        kstate = true;
        kbuf = c;
    } else { // 4x8font
        drawfont4(c);
    }
}

void draws(const unsigned char *s){
    unsigned char c;
    while((c = *s++) != '\0') drawc(c);
}

Serial sio(USBTX, USBRX);

int main() {
    unsigned char c;

    sio.baud(115200);
    while(1){
        c = sio.getc();
        if(c == 0x0d){
            newline();
        } else {
            drawc(c);
        }
    }
}
