#include "mbed.h"
#include "TM1637.h"

#include "Font_7Seg.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);  //NOTE: On F401 LED1 is Pin D13, which is SCK!

// DisplayData_t size is 6 bytes (6 Grids @ 8 Segments) 
TM1637::DisplayData_t all_str   = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};  
TM1637::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};  
TM1637::DisplayData_t hello_str = {C7_H, C7_I, 0x00, 0x00, 0x00, 0x00};
//TM1637::DisplayData_t cls_str   = {0x00, 0x00, 0x00, 0x00};  
//TM1637::DisplayData_t hello_str = {C7_H, C7_I, 0x00, 0x00};

TM1637::KeyData_t keydata;

//TM1637 TM1637(D4, D5);     //F303K8
TM1637_EYEWINK TM1637(D4, D5);     //F303K8


void show_menu() {
    //pc.printf("0:   Exit\n\r");
    pc.printf("1:   All\n\r");
    pc.printf("2:   Cls\n\r");
    pc.printf("3:   Show all segs\r\n");
    pc.printf("s:   Timer 20s\r\n");
}


char cmd, bits;
int main() {
    
    pc.printf("Hello World\r\n");
    
    TM1637.cls();
    TM1637.setBrightness(TM1637_BRT3);
    TM1637.writeData(all_str);
    wait(0.5);
    TM1637.setBrightness(TM1637_BRT0);
    wait(0.5);
    TM1637.setBrightness(TM1637_BRT3);
    
    show_menu();
    
    Timer timer;
    
    while (1) {
        cmd = pc.getc();

        switch (cmd) {
        case '1':
            TM1637.cls();
            TM1637.writeData(all_str);
         break;
               
        case '2':
            TM1637.cls();
            TM1637.writeData(cls_str);
         break;
               
        case '3':
            //test to show all segs
            pc.printf("Show all segs\r\n");
            wait(1);
            TM1637.cls();
         
            //for (int i=0; i<TM1637_DISPLAY_MEM; i++) {
            for (int i=0; i<4; i++) {
                for (int bit=0; bit<8; bit++) {
                    TM1637.cls();
                    
                    bits = 0x01 << bit;
                    TM1637.writeData(bits, i);
                    
                    pc.printf("Idx = %d, Bits = 0x%02x\r\n", i, bits);
                    cmd = pc.getc(); // wait for key
                }
            }
            pc.printf("Show all segs done\r\n");
            break;
            
        /*
        case '4':
            TM1637.cls();
            TM1637.printf("1");
            break;
            
        case '5':
            TM1637.cls();
            TM1637.printf("   1");
            break;
            
        case '6':
            TM1637.cls();
            float data = 3.26;
            TM1637.printf(" %2.2f", data);
            break;
        */
        
        case 's':
            timer.reset();
            timer.start();
            while(timer.read() < 20.0f){
                float time = timer.read();
                TM1637.cls();
                if (time < 10.0f){
                    TM1637.printf(" %.2f", time);
                }
                else{
                    TM1637.printf("%.2f", time);
                }
            }
            timer.stop();
            wait(1.0f);
            TM1637.cls();
            break;
            
        default:
            break;
    } //switch cmd

    myled = !myled;
    wait(0.2);      
    } //while
}


