#include "Motor_lib.h"
#include "mbed.h"

Motor_lib :: Motor_lib(PinName pin1, PinName pin2) : out1(pin1),out2(pin2){
    mlib = this;
    out1 = 0;
    out2 = 0;
    status = 0;
}

void Motor_lib :: turn_a(){
    out1 = 1;
    out2 = 0;
    status = 1;
}

void Motor_lib :: turn_a(float power){
    out1 = power;
    out2 = 0;
    status = power;
}

void Motor_lib :: turn_b(){
    out1 = 0;
    out2 = 1;
    status = -1;
}

void Motor_lib :: turn_b(float power){
    out1 = 0;
    out2 = power;
    status = power * -1;
}

void Motor_lib :: stop(){
    out1 = 0;
    out2 = 0;
    status = 0;
}

void Motor_lib :: break_stop(float time){
    out1 = 1;
    out2 = 1;
    status = 0;
    stopTime.attach(mlib, &Motor_lib::stop, time);
}

void Motor_lib :: break_stop(){
    out1 = 1;
    out2 = 1;
    status = 0;
    stopTime.attach(mlib, &Motor_lib::stop, 0.1f);
}