#ifndef SIGFOX_H
#define SIGFOX_H

#include "mbed.h"

//Define your baudrate and pins here
#define BAUDRATE     9600
#define PIN_RX      PA_10
#define PIN_TX      PA_9

class Sigfox_ {

public:
    Sigfox_();
    //Sigfox_(PinMode TX, PinMode RX);
    
    void begin();
    bool isReady();
    bool send(const void* data, uint8_t len);
    unsigned long getID();
    unsigned long getPAC();
    bool setPowerMode(uint8_t power);

    enum RETURN_CODE {
        OK = 'O',
        KO = 'K',
        SENT = 'S'
    };
    
private:
    //Serial device(p9, p10); 
    //Serial _serial;
    unsigned long _lastSend;

    uint8_t _nextReturn();
};

extern Sigfox_ Sigfox;
#endif