#include "mbed.h"
#include "millis.h"
#include "sigfox.h"

Sigfox_ Sigfox;

Sigfox_::Sigfox_()  {
    Serial device(PIN_TX, PIN_RX);
    _lastSend=-1;
}

uint8_t Sigfox_::_nextReturn() {
    Serial sc(SERIAL_TX, SERIAL_RX, 9600);
    Serial device(PIN_TX, PIN_RX);     
    char fstChar = device.getc();
    sc.printf("hola\n");
   // while(device.getc() != ';');
    sc.printf("momo\n");
    return fstChar;
}

void Sigfox_::begin () {
    Serial device(PIN_TX, PIN_RX); 
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)';');
    
    //while(device.available() < 3);

    device.getc(); //'K'
    device.getc(); //'O'
    device.getc(); //';'
}

bool Sigfox_::isReady() {
    Serial device(PIN_TX, PIN_RX);

   /* unsigned long currentTime = millis();
    if(currentTime >= _lastSend && (currentTime - _lastSend) <= 600000) {
        return false;
    }*/
    // Time is ok, ask the modem's status
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)'A');
    device.putc((uint8_t)'T');
    device.putc('\r');
    //device.putc((uint8_t)';');
    
    
   // return _nextReturn() == OK;
    return true;
}
 
bool Sigfox_::send(const void* data, uint8_t len) {
    Serial sc(SERIAL_TX, SERIAL_RX, 9600);
    sc.printf("sending ... \n");
    
    uint8_t* bytes = (uint8_t*)data;
   // _lastSend = millis();
    Serial device(PIN_TX, PIN_RX);
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)'A');
    device.putc((uint8_t)'T');
    device.putc((uint8_t)'$');
    device.putc((uint8_t)'S');
    device.putc((uint8_t)'F');
    device.putc((uint8_t)'=');
    
    sc.printf("coucou 0\n");
    for(uint8_t i = 0; i < len; ++i) {
        device.putc(bytes[i]);
    }
    device.putc('\r');
    sc.printf("coucou 1 \n");
   /* uint8_t ok = _nextReturn();
    if(ok == OK) {
        _nextReturn(); //SENT
        return true;
    }
    sc.printf("coucou 2\n");
    return false;*/
    return true;
}

unsigned long Sigfox_::getID() {
    unsigned long id = 0;
    Serial device(PIN_TX, PIN_RX);
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)'A');
    device.putc((uint8_t)'T');
    device.putc((uint8_t)'$');
    device.putc((uint8_t)'I');
    device.putc((uint8_t)'=');
    device.putc((uint8_t)'1');
    device.putc((uint8_t)'0');
    device.putc('\r');
    
    uint8_t response[8] = {0};
    uint8_t i = 0;
    for (i = 0; i<7;++i) {
        response[i] = device.getc();
        ++i;
    }
    /*uint8_t response[8] = {0};
    while(device.getc() != '\0') {
        response[i] = device.getc();
        while(!device.readable());
        ++i;
    }*/
    device.getc(); //';'
    for(uint8_t j = 0; j < i; ++j) {
        id += response[j] << ((i-3-j) * 8);
    }
    return id;
}

unsigned long Sigfox_::getPAC() {
    unsigned long id = 0;
    Serial device(PIN_TX, PIN_RX);
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)'A');
    device.putc((uint8_t)'T');
    device.putc((uint8_t)'$');
    device.putc((uint8_t)'I');
    device.putc((uint8_t)'=');
    device.putc((uint8_t)'1');
    device.putc((uint8_t)'1');
    device.putc('\r');
    
    uint8_t response[8] = {0};
    uint8_t i = 0;
    for (i = 0; i<7;++i) {
        response[i] = device.getc();
        ++i;
    }
    
    for(uint8_t j = 0; j < i; ++j) {
        id += response[j] << ((i-3-j) * 16);
    }
    return id;
}

bool Sigfox_::setPowerMode(uint8_t power) {
    Serial device(PIN_TX, PIN_RX);
    device.putc((uint8_t)'\0');
    device.putc((uint8_t)'A');
    device.putc((uint8_t)'T');
    device.putc((uint8_t)'$');
    device.putc((uint8_t)'I');
    device.putc((uint8_t)'=');
    device.putc(power);
    device.putc('\r');

    //return _nextReturn() == OK;
    return 1;
}

//------------------------------------------------------------------------------------------------//
//Destructors

/*sigfox::~sf() {
}*/