#ifndef MESSAGE_H
#define MESSAGE_H

#include "mbed.h"

#define PIN_RX      PA_15
#define PIN_TX      PA_2
class Message {
    public:
        //Methodes:
        
        //constructeur
        Message(int messageType):m_messageType(messageType), sigfox(PIN_TX, PIN_RX){};
        
       virtual void send() = 0;
        
        //Accesseurs
        int getMessageType(){
            return m_messageType;
        };
        
   
    protected:
    
        int floatToHex(float a) const{
            int q = *(int*)&a;
            return q;
        };
        
        void writeInSendBuffer(int16_t var){
            if(var > 0 && var < 4096) this->sigfox.printf("0%hx", var);
            else this->sigfox.printf("%hx", var);
        };
        
        /*void writeInSendBuffer(float var){
    
            if(var > 0 && var < 4096) this->sigfox.printf("0%x", var);
            else this->sigfox.printf("%x", var);
        };*/
        
        int16_t parseToInt16_t(int var){
            int16_t temp = var * 100;
            return temp;
        };
        
        int16_t parseToInt16_t(float var){
            int16_t temp = var * 100;
            return temp;
        };
        
        int m_messageType;
        Serial sigfox;
        
    
};


#endif
