#include "mbed.h"
#include "message_1.h"
#include "DHT22.h"
#include "HX711.h"
#include "DS1820.h"

using namespace std;

// fonction de mesure de donnees
void mesureTempExtHumidite(int &humidite, float &temperature); 
void mesureTempInt(float &temperatureInt);
void mesureMasse(float &masse, long valeurTare);
void mesureGps(float &longit, float &lat);
DigitalOut myled(D13); // debug led 
//Serial sc(SERIAL_TX, SERIAL_RX, 9600); // mode debug le decommenter pour afficher les mesures des capteurs dans le moniteur serie

DHT22 dht22(D3); // capteur de temperature et d'humidite
HX711 Balance(D12,D11); // capteur de poids
DS1820 probe = A6; // sonde 

int main() {
  
    float temperature_actuelle;  
    float temperature_ref=24; 
    float delta; 
    float asser_err= -0.15; //coefficient de correction
    
    float masse_reelle; 
    float longit = 12.3, lat = 18.6;
    int humidite= 18;  
    float temperatureExt = 12;
    float temperatureInt = 15;
    
   
    
    long valeur;
    long valeurTare ;
    float masse=13.2;
   
    
    valeurTare = Balance.getValue();  
    probe.search_ROM(); // mise en marche de la sonde
    
    while(1) {
        mesureTempExtHumidite(humidite, temperatureExt);
        mesureMasse(masse, valeurTare);
        mesureTempInt(temperatureInt);
        //sc.printf("temperature externe: %.2f humidity: %d temperature interne: %.2f \n\r",temperatureExt, humidite, temperatureInt);
        //sc.printf("masse: %f\n\r", masse);  // mode debug dans le moniteur serie... 
        
        //Correction de la masse
        temperature_actuelle=temperatureExt;
        delta=temperature_ref - temperature_actuelle;  
        masse_reelle=masse+(delta*asser_err);
      
                
        Message_1 msg1(temperatureExt, temperatureInt, humidite, masse_reelle); // instanciation du corps du message avec les données à envoyer
        msg1.send();
        
        wait(600); // envoie toutes les 10 min
    }
}

void mesureTempExtHumidite(int &humidite, float &temperatureExt){
    dht22.sample() ;
    humidite=dht22.getHumidity()/10.0;
    temperatureExt=dht22.getTemperature()/10.0;
};

    
void mesureMasse(float &masse, long valeurTare){
    wait_ms(200);                                                       // Attente de 200 millisecondes
    float valeur = Balance.getValue();                                        // On récupère la valeur du module
    masse = ((double)valeur-(double)valeurTare)/11900; // coeff de calibrage des jauges
};

void mesureTempInt(float &temperatureInt){
    probe.convert_temperature(DS1820::all_devices);
    temperatureInt = probe.temperature('c');
};

void mesureGps(float &longit, float &lat){  // le Gps n'a pas ete implemente par soucis de consommation energetique.
};

