#include "mbed.h"
#include <iostream>
#include <vector>
#include "sigfox.h"
#include "SoftSerial.h"
#include "message_1.h"
#include "message_2.h"
#include "DHT22.h"
#include "HX711.h"
#include "DS1820.h"

using namespace std;

void mesureTempExtHumidite(int &humidite, float &temperature);
void mesureTempInt(float &temperatureInt);
void mesureMasse(float &masse, long valeurTare);
void mesureGps(float &longit, float &lat);
DigitalOut myled(D13);
//Serial sc(SERIAL_TX, SERIAL_RX, 9600);
//Serial device(PA_9, PA_10);
DHT22 dht22(D3);
HX711 Balance(D12,D11);
DS1820 probe = A6;

//SoftSerial device(D3, D4);
//Serial sc2(D5, D4);


int main() {
   // device.baud(9600);
    //sc.printf("---New start ---\n");
   // while (!device.writeable()) { }
    //sc.printf("coucou 1 \n");
    
   /* device.printf("AT\r");;
    char a = device.getc();
    char b = device.getc();
    sc.printf("%c%c \n", a, b);
    sc.printf("%c", device.getc());
    */
    float longit = 12.3, lat = 18.6;
    int humidite= 18;  
    float temperatureExt = 12;
    float temperatureInt = 15;
    
    long valeur;
    long valeurTare ;
    float masse=13.2;;
    
    valeurTare = Balance.getValue();  
    probe.search_ROM();
    char temp;
    while(1) {
        mesureTempExtHumidite(humidite, temperatureExt);
        mesureMasse(masse, valeurTare);
        mesureTempInt(temperatureInt);
        //sc.printf("temperature externe: %.2f humidity: %d temperature interne: %.2f \n\r",temperatureExt, humidite, temperatureInt);
        //sc.printf("masse: %f\n\r", masse);

        Message_1 msg1(1, temperatureExt, temperatureInt, humidite, masse);
        msg1.send();
        
        myled = 1 ;
        wait(10);//10 s intervalle du temps entre chaque envoi des données 
        myled = 0 ;
    }
}

void mesureTempExtHumidite(int &humidite, float &temperatureExt){
    dht22.sample() ;
    humidite=dht22.getHumidity()/10.0;
    temperatureExt=dht22.getTemperature()/10.0;
   // humidite = 57;
   // temperatureExt = 17;
};

void mesureMasse(float &masse, long valeurTare){
    wait_ms(200);                                                       // Attente de 200 millisecondes
   float valeur = Balance.getValue();                                        // On récupère la valeur du module
    masse = ((double)valeur-(double)valeurTare)/-11900;
};

void mesureTempInt(float &temperatureInt){
    probe.convert_temperature(DS1820::all_devices);
    temperatureInt = probe.temperature('c');
};

void mesureGps(float &longit, float &lat){
};

/*bool sendMessageToSigfox(Vector<Message*> msg){
    for(int i =0; i<msg.size(); i++){
        msg[i].send();
        wait_ms(100);
    };
};*/
