#ifndef MESSAGE_1_H
#define MESSAGE_1_H

#include "mbed.h"
#include "message.h"

class Message_1 : public Message {
    public:
        //Methodes:
        
        //constructeur
        Message_1(float tempExt, float tempInt, int humidite, float masse):Message(){
            this->m_tempExt = this->parseToInt16_t(tempExt);
            this->m_tempInt = this->parseToInt16_t(tempInt);
            this->m_humidite = this->parseToInt16_t(humidite);
            this->m_masse = this->parseToInt16_t(masse); 
        };
            
        void send(){  //envoie de donnee a sigfox
            char donnee[] = "AT$SF=";
            this->sigfox.printf(donnee);
            this->writeInSendBuffer(this->m_tempExt);
            this->writeInSendBuffer(this->m_tempInt);
            this->writeInSendBuffer(this->m_humidite);
            this->writeInSendBuffer(this->m_masse);
            this->sigfox.printf("\r");
        };
     
        //Accesseurs
        int getTempExt() const{
            return this->m_tempExt;
        };
        
        int getTempInt() const{
            return this->m_tempInt;
        };
        
        int getHumidite() const{
            return this->m_humidite;
        };
        
        float getMasse() const{
            return this->m_masse;
        };
        
    private:
        int16_t m_tempExt;
        int16_t m_tempInt;
        int16_t m_humidite;
        int16_t m_masse;
        
};


#endif