#ifndef MESSAGE_H
#define MESSAGE_H

#include "mbed.h"

#define PIN_RX      PA_15 // PA_15 n'est pas present dans le nucleo STM32L432C.. 
#define PIN_TX      PA_2 // Pour l'envoie de donnee juste le TX (PA_2) est necessaire
class Message {
    public:
        //Methodes:
        
        //constructeur
        Message():sigfox(PIN_TX, PIN_RX){};
        
        //Methode
        virtual void send() = 0;
        
     
   
    protected:
        
        void writeInSendBuffer(int16_t var){
            if(var > 0 && var < 4096) this->sigfox.printf("0%hx", var); // 4095 donne en hexa 0x0FFF sur 16 bits, le printf ecris 0xFFF en omettant le 0 ce qui
            else this->sigfox.printf("%hx", var);                       // induit le parsing coté sigfox en erreur car le 0 ne sera pas pris en compte dans la 
        };                                                              // reconversion en int16. 4096 est dont le seuil.
        
        
        int16_t parseToInt16_t(int var){ // toutes nos données sont codées sur 16 bits. 2 chiffres sont gardés apres la virgule 
            int16_t temp = var * 100;
            return temp;
        };
        
        int16_t parseToInt16_t(float var){ // surcharge de fonction pour les floatants
            int16_t temp = var * 100;
            return temp;
        };
        Serial sigfox; // declaration de la communication serie avec le module wisol
        
    
};


#endif
