#include "mbed.h"
#include "Camera_LS_Y201.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

Camera_LS_Y201 cam(p13, p14);
DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
AnalogIn sensor(p20);           /*input from analog phidget motion sensor*/

LocalFileSystem fs("webfs");    /*local filesystem*/

EthernetNetIf eth;
HTTPServer svr;

FILE *fp;
int count =0;

void callback_func(uint8_t *buf, size_t siz) {
    fwrite(buf, siz, 1, fp);
}

int main(void) {

    float level1 , level2 = 1.0;

    Base::add_rpc_class<DigitalOut>();

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");

    char test[64];

    wait(1);

    printf("reset=%d\n", cam.reset());
    wait(1);

#if 0
    printf("setImageSize=%d\n", cam.setImageSize(LS_Y201::ImageSize640x480));
    wait(1);
#endif


    while (count <5) {                                                  /*loop to catch five consecutive motions in the form of pictures*/
        level1 = sensor.read();
        level2 = (level2 * .8 + level1 * .2);                           /* running average filter*/
        printf("value of sensor = %f and value of level2 is = %f \n\r", level1, level2);

        if ((level2) < 0.67) {
            
            printf("reset=%d\n", cam.reset());                          /*reset after each picture*/
            wait(1);

            char format[] = "/webfs/test%d.jpg";
            char filename[sizeof(format)+100];
            sprintf(filename,format,count);
            printf("file name is %s\n", filename);
            fp = fopen(filename,"wb");



            if (fp == NULL) {
                error("Failure to open a destination file.");
            }
            wait(1);
            
            printf("takePicture=%d\n", cam.takePicture());              /*clicking the picture*/
            wait(1);

            int fs;
            printf("readJpegFileSize=%d\n", cam.readJpegFileSize(&fs));
            printf("\tFile size = %d\n", fs);
            wait(1);

            printf("readJpegFileContent=%d\n", cam.readJpegFileContent(callback_func));
            wait(1);

            fclose(fp);

            FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
            FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
            svr.addHandler<SimpleHandler>("/hello");
            svr.addHandler<RPCHandler>("/rpc");
            svr.addHandler<FSHandler>("/files");
            svr.addHandler<FSHandler>("/"); //Default handler
            //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm

            svr.bind(80);
            count++;
        } else {
            printf("no motion");
        }
    }


    printf("Listening...\n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (true) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }


    return 0;
}













