/**
*   Author: Rob Hyams
*   Date:   12.05.2011
*   This is a beta library for use with I2C1. The standard mbed I2C
*   is not currently functioning when using the v29 beta library.
*   Therefore, this has been developed as a drop in replacement.
*   Code is not particularly robust, but will handle incorrect
*   communication by checking states.
*
*   Has been developed and tested with ADXL345 accelerometer
*/



#ifndef I2CR_H
#define I2CR_H

#include "mbed.h"

class I2CR {

public:
    //Constructor
    I2CR();
    
    //Write function
    int write(int address, const char* data, int length);
    
    //Read function
    int read(int address, char* data, int length);

};

#endif