//展開刃用プログラム
//

#include "mbed.h"
#include "ReceiverIR.h"
#include "AQM0802A.h"

Serial pc(SERIAL_TX, SERIAL_RX);
RemoteIR::Format format;

//機能制限 ----------------------------------------------------------------------
#define L_Check
#define E_Check

//サウンド  ---------------------------------------------------------------------
#define mC 261.626 //ド
#define mD 293.665 //レ
#define mE 329.628 //ミ
#define mF 349.228 //ファ
#define mG 391.995 //ソ
#define mA 440.000 //ラ
#define mB 493.883 //シ
#define mC2 523.252 //ド

//モーター番号    ----------------------------------------------------------------
#define L 1
#define R 2

//モーター回転方向  --------------------------------------------------------------
#define P 1   //順方向
#define M 2   //逆方向

//リモコン受信設定  --------------------------------------------------------------
#define start 1 //開始信号
#define end 2   //終了信号

//方向指示  ---------------------------------------------------------------------
#define front 1 //前進
#define back 2  //後退
#define right 3 //右転回
#define left 4  //左転回
#define stop 5  //停止(モーター回転停止：PWM=0)

//SG90  ------------------------------------------------------------------------
#define start_plus 500  //-90
#define end_plus 2400   //+90


//スイッチ  ---------------------------------------------------------------------
DigitalIn select(PA_9); //選択ボタン
DigitalIn decide(PA_10);//決定ボタン


//ブザー   ---------------------------------------------------------------------
PwmOut buzer(PB_5);


//センサー  ---------------------------------------------------------------------
DigitalIn ls[4]={PB_9,PB_8,PC_7,PB_10};     //左前、右前、右後、左後
AnalogIn es[4]={PB_15,PB_14,PB_12,PB_13};   //左前、右前、右後、左後


//モーター  ---------------------------------------------------------------------
DigitalOut MR[2]={PA_7,PA_6};    //右モーター回転方向指定ピン
DigitalOut ML[2]={PA_5,PA_3};    //左モーター回転方向指定ピン
PwmOut Rduty(PB_7); //右モーターPWM
PwmOut Lduty(PA_0); //左モーターPWM


//サーボモータ
PwmOut servo(PB_10); //SG90


//LCD---------------------------------------------------------------------------
AQM0802A lcd(PC_12, PA_8); //sda,scl


//リモコン受信モジュール   --------------------------------------------------------
ReceiverIR ir_rx(PC_0);

//変数    -----------------------------------------------------------------------
int mode=0;     //0:モード割り振り無し　1:動作開始　2:動作停止
int flag = 0;   //定義:0 逆転:1
int Lflag = 0;  //白線検知中は1,それ以外は0
int Eflag = 0;  //敵検知中は1,それ以外は0
int Mflag = 0;  //動作プログラム識別用flag 0: 1: 2:

//モーター出力    ----------------------------------------------------------------
float duty = 0.5;   //モーター出力PWM
float max = 0.8;    //最大出力PWM

//敵検知距離(0~65535)    --------------------------------------------------------
int dis = 32767;

//敵検知判断用配列
int ans[4] = {0};

//タイマー割り込み  --------------------------------------------------------------
Ticker timer;  //リモコン受信用

//関数一覧  ---------------------------------------------------------------------
void ServoInit();   /*サーボモータ初期化*/
void Servo();       /*サーボモータ動作*/
void Buzer();       /*ブザー*/
void IRswitch();     /*リモコン受信*/
void IRclear();     /*受信初期化*/
void Motor();       /*モーター回転*/
void Move();        /*機体動作*/
void Line();        /*白線検知動作*/
void LineCheck();   /*白線検知確認*/
void Enemy();       /*敵検知動作*/
void EnemyCheck();  /*敵検知確認*/
void Priority();    /*優先決定*/
void Select();      /*モード選択*/
void Battle();      /*戦闘用*/
void Init();        /*初期化*/

//サーボモータ初期化
void ServoInit(){
    servo.period_ms(20);
    servo = 1.0;
    servo.pulsewidth_us(start_plus);
}


//サーボモータ動作
//プログラム開始時に展開刃を開く動作を行う
void Servo(int plus){
    servo.pulsewidth_us(plus);
}


//ブザー   ----------------------------------------------------------------------
//sound:音階 time:時間(s) どの音を何秒間鳴らすか
void Buzer(float sound,float time){
    double mm[8]={mC,mD,mE,mF,mG,mA,mB,mC2};
    
    //ド
    if(sound == mm[0]){
        buzer.period(1.0/mm[0]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //レ
    if(sound == mm[1]){
        buzer.period(1.0/mm[1]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //ミ
    if(sound == mm[2]){
        buzer.period(1.0/mm[2]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //ファ
    if(sound == mm[3]){
        buzer.period(1.0/mm[3]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //ソ
    if(sound == mm[4]){
        buzer.period(1.0/mm[4]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //ラ
    if(sound == mm[5]){
        buzer.period(1.0/mm[5]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //シ
    if(sound == mm[6]){
        buzer.period(1.0/mm[6]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
    //ド
    if(sound == mm[7]){
        buzer.period(1.0/mm[7]);
        buzer.write(0.5f);
        wait(time);
        buzer.write(0.0f);
    }
}

//リモコン設定    ----------------------------------------------------------------
void IRswitch(){
    uint8_t buf[32];
    int bitcount;
    
    if(ir_rx.getState() == ReceiverIR::Received){
        bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);

        if((bitcount !=0)){
            for(int i=0;i<sizeof(buf);i++){
                pc.printf("%x,",buf[i]);
                if(i > 8){
                    pc.printf("\r\n");
                    break;
                }
            }
            
            if(buf[2]==0x00 && buf[3]==0xff){
                mode = start;
                pc.printf("start\n\r");
            }
            else if(buf[2]==0x31 && buf[3]==0xce){
                mode = stop;
                pc.printf("stop\n\r");
            }
        }
    }
}

void IRclear(){
    uint8_t buf[32];

    while (ir_rx.getState() == ReceiverIR::Received){
        ir_rx.getData(&format, buf, sizeof(buf) * 8);
    }
}

//モーター回転方向  ----------------------------------------------------------------
//回転方向の指示だけ。出力は動作指示の関数[Move()]で決定。
//P:正方向回転 M:逆回転方向
void Motor(int motor,int direction){
    switch(motor){
        //左モーター
        case L:
        //順方向回転
        if(direction == P){
            ML[0] = 1;
            ML[1] = 0;
        }
        //逆方向回転
        else if(direction == M){
            ML[0] = 0;
            ML[1] = 1;
        }
        break;
        
        //右モーター
        case R:
        //順方向回転
        if(direction == P){
            MR[0] = 1;
            MR[1] = 0;
        }
        //逆方向
        else if(direction == M){
            MR[0] = 0;
            MR[1] = 1;
        }
        break;
    }
}

//動作    --------------------------------------------------------------------------
//動作パターンの決定とPWMの値を決めることで、その出力で動作を行う関数
void Move(int patern,float d){
    switch(patern){
        //前進
        case front:
        if(flag == 0){
            Lduty = d;
            Rduty = d;
            Motor(L,P);
            Motor(R,P);
        }
        else if(flag == 1){
            Lduty = d;
            Rduty = d;
            Motor(L,M);
            Motor(R,M);
        }
        break;
        
        //後退
        case back:
        if(flag == 0){
            Lduty = d;
            Rduty = d;
            Motor(L,M);
            Motor(R,M);
        }
        else if(flag == 1){
            Lduty = d;
            Rduty = d;
            Motor(L,P);
            Motor(R,P);
        }
        break;
        
        //転回:左
        case left:
        if(flag == 0){
            Lduty = d;
            Rduty = d;
            Motor(L,M);
            Motor(R,P);
        }
        else if(flag == 1){
            Lduty = d;
            Rduty = d;
            Motor(L,P);
            Motor(R,M);
        }
        break;
        
        //転回:右
        case right:
        if(flag == 0){
            Lduty = duty;
            Rduty = duty;
            Motor(L,P);
            Motor(R,M);
        }
        else if(flag == 1){
            Lduty = duty;
            Rduty = duty;
            Motor(L,M);
            Motor(R,P);
        }
        break;
        
        //stop信号だけ、dutyを指定されても強制的にduty = 0とする
        case stop:
            Lduty = 0;
            Rduty = 0;
            Motor(L,P);
            Motor(R,P);
        break;
    }
}


//白線    --------------------------------------------------------------------------
void Line(){
    switch(flag){
        //定義向き***************************************************************
        case 0:
            //LF & RF
            if(ls[0]==1&&ls[1]==1){
                Move(back,duty);
                wait(0.1);
                flag = 1;
            }
            //LF
            else if(ls[0]==1){
                Move(left,duty);
                wait(0.1);
                Move(back,duty);
                flag = 1;
            }
            //RF
            else if(ls[1]==1){
                Move(right,duty);
                wait(0.1);
                Move(back,duty);
                flag = 1;
            }
            //LB RB
            else if(ls[2]==1||ls[3]==1){
                Move(front,max);
            }
        break;
        
        //前後逆転時*************************************************************
        case 1:
        //LF & RF
        if(ls[2]==1&&ls[3]==1){
            Move(back,duty);
            wait(0.1);
            flag = 0;
        }
        //LF
        else if(ls[2]==1){
            Move(left,duty);
            wait(0.1);
            Move(back,duty);
            flag = 0;
        }
        //RF
        else if(ls[3]==1){
            Move(right,duty);
            wait(0.1);
            Move(back,duty);
            flag = 0;
        }
        //LB RB
        else if(ls[0]==1||ls[1]==1){
            Move(front,max);
        }
        break;
    }
}

//白線チェック
/*LCDの四隅に0-1を表示で確認*/
#ifdef L_Check
void LineCheck(){
    int roop=0;
    
    while(roop == 0){
        //LF
        if(ls[0] == 0){
            lcd.setCursor(0,0);
            lcd.printf("0");
        }
        else if(ls[0] == 1){
            lcd.setCursor(0,0);
            lcd.printf("1");
        }
        
        //RF
        if(ls[1] == 0){
            lcd.setCursor(7,0);
            lcd.printf("0");
        }
        else if(ls[1] == 1){
            lcd.setCursor(7,0);
            lcd.printf("1");
        }
        
        //RB
        if(ls[2] == 0){
            lcd.setCursor(7,1);
            lcd.printf("0");
        }
        else if(ls[2] == 1){
            lcd.setCursor(7,1);
            lcd.printf("1");
        }
        
        //LB
        if(ls[3] == 0){
            lcd.setCursor(0,1);
            lcd.printf("0");
        }
        else if(ls[3] == 1){
            lcd.setCursor(0,1);
            lcd.printf("1");
        }
        
        //ループ脱出
        if(decide == 1){
            roop =! roop;
            break;
        }
    }
}
#endif    


//敵検知   ----------------------------------------------------------------------
void Enemy(){
    //前後反転用flag
    if(ans[0]==1 || ans[2]==1){
        flag = 0;
    }
    if(ans[1]==1 || ans[3]==1){
        flag = 1;
    }
    
    //機体進行方向からみて、左・右に敵が検知できた時
    if(ans[0] == 1 || ans[2] == 1){
        Move(left,duty);
    }
    else if(ans[1] == 1 || ans[3] == 1){
        Move(right,duty);
    }else{
        Move(front,duty);
    }
}

//敵検知チェック
/*ブザーで確認。検知できているセンサーによって音色を変える。*/
#ifdef E_Check
void EnemyCheck(){
    if(ans[0] == 0){
        lcd.setCursor(0,0);
        lcd.printf("0");
    }else if(ans[0] == 1){
        lcd.setCursor(0,0);
        lcd.printf("1");
    }
    
    if(ans[1] == 0){
        lcd.setCursor(7,0);
        lcd.printf("0");
    }else if(ans[1] == 1){
        lcd.setCursor(7,0);
        lcd.printf("1");
    }
    
    if(ans[2] == 0){
        lcd.setCursor(7,1);
        lcd.printf("0");
    }else if(ans[2] == 1){
        lcd.setCursor(7,1);
        lcd.printf("1");
    }
    
    if(ans[3] == 0){
        lcd.setCursor(0,1);
        lcd.printf("0");
    }else if(ans[3] == 1){
        lcd.setCursor(0,1);
        lcd.printf("1");
    }
}
#endif


//白線検知、敵検知　優先-----------------------------------------------------------
void Priority(){
    int a;
    
    //白線判断
    if(ls[0]==1 || ls[1]==1 || ls[2]==1 || ls[3]==1){
        Lflag = 1;
    }else{
        Lflag = 0;
    }
    
    //敵検知判断
    for(int i=0;i<4;i++){
       a = es[i].read_u16();
       if(a > dis){
           ans[i] = 1;
        }
    }
    
    if(ans[0] == 1 || ans[1] == 1 || ans[2] == 1 || ans[3] == 1){
        Eflag = 1;
    }
    else{
        Eflag = 0;
    }
    
    //優先
    if(Lflag == 1 && Eflag == 1){
        Line();
    }
    else{
        Line();
        Enemy();
    }
}


//動作プログラム選択 --------------------------------------------------------------
void Select(){
    int count=0;
    int roop=0;
    
    while(roop == 0){
        lcd.cls();
        
        //モード選び・表示
        switch(count){
            case 0:
            lcd.setCursor(0,0);
            lcd.printf("L-check");
            break;
            
            case 1:
            lcd.setCursor(0,0);
            lcd.printf("E-check");
            break;
            
            case 2:
            lcd.setCursor(0,0);
            lcd.printf("Battle");
            break;
            
        }
        
        //選択ボタンを押したら
        if(select == 1){
            count++;
            if(count == 3){
                count = 0;
            }
        }
        
        //決定ボタンを押したら
        if(decide == 1){
            Mflag = count;
            roop =! roop;
            break;
        }
    }
}

//取り組み  ---------------------------------------------------------------------
void Battle(){
    timer.attach(&IRswitch,0.1);
    wait(5.0);
    Servo(end_plus);
    while(mode != stop){
        Priority();
    }
}

//初期化   ----------------------------------------------------------------------
void Init(){
    lcd.cls();
    Move(stop,0);
    ServoInit();
}

//メイン   ----------------------------------------------------------------------
int main(void){
    Init();
    lcd.printf("Wait");
    wait(3.0);
    lcd.cls();
    
    Select();
    
    switch(Mflag){
        case 0:
        LineCheck();
        break;
        
        case 1:
        EnemyCheck();
        break;
        
        case 2:
        Battle();
        break;
    }
}

