#include "mbed.h"

#define     PICOJSON_ASSERT
#define     ENDL "\r"<<endl

#include <picojson.h>
#include <fstream>
#include <iostream>
#include <cassert>
#include <memory>
#include <string>

LocalFileSystem local("local");


using namespace std;
using namespace picojson;
Serial pc(USBTX,USBRX);

int main() {
    picojson::value root;
    ifstream stream("/local/example.txt",ios::in);
    if ( !stream.is_open() ) {
        pc.printf("File Opening Error\n\r");
        return 1;
    }
    stream >> root;
//    cout << root.serialize() << "\r" << endl;
//    assert(get_last_error().empty() );
    object image = root.get<object>()["Image"].get<object>();
    cout << "Width=" << image["Width"].get<double>() << "\r\n";
    cout << "Height=" << image["Height"].get<double>() << "\n\r";
    cout << "Title=" << image["Title"].get<string>() << "\r" << endl;
    array  ids = image["IDs"].get<array>();
    int i = 0;
    for (i=0; i<ids.size(); i++) {
        cout << "ID["<<i<<"]: " << ids[i].get<double>() << "\r" << endl;
    }
}

/*---example.txt---*/
/*
{
    "Image": {
        "Width": 800,
        "Height": 600,
        "Title": "from 15 step",
        "Thumbnail": {
            "Url": "http://asdasd",
            "Height": 125,
            "Weidth": "100"
        },
        "IDs": [116, 943,234, 11112]
    }
}*/

/* 実行結果:
Width=800
Height=600
Title=View from 15th Floor
116
943
234
38793
*/