/* Copyright C2014 ARM, MIT License
 *
 * Author: Doug Anson (doug.anson@arm.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
//#include <string>
#include <fstream>

// Blinky
DigitalOut led(LED1);

EthernetInterface* eth;
Websocket* webSock;

string type;
string id;
string zone;
string alert_level;

int init_identity()
{
    char a;
    // find 
    while (infile >> a)
    {
        
    }
    /*std::ifstream infile("config");
    
    std::getline(infile, type);
    std::getline(infile, id);*/
    /*std::getline(infile, zone);
    std::getline(infile, alert_level);*/
}

int init_web_socket()
{
    eth = new EthernetInterface();
    while (eth->get_ip_address()[0] == 0)
    {
        eth->connect();
    }
    printf("IP Address is %s\n\r", eth->get_ip_address());
    
    webSock = new Websocket("ws://10.163.0.100:8000/", eth);
    int connect_error = webSock->connect();
    while (connect_error != 0)
    {
        connect_error = webSock->connect();
    }
    
    wait(0.5);
    return 0;
}

int send_connection_message()
{
    // TODO read config file to get real entity type and id
    string entity_type = "sensor";
    string entity_id = "C48";
    string msg = "{\"message_id\":\"connection\", \"entity_type\":\"" + entity_type + "\", \"entity_id\":\"" + entity_id +"\"}";
    
    if (webSock)
    {
        char *cstr = new char[msg.length() + 1];
        strcpy(cstr, msg.c_str());
        int err = webSock->send(cstr);
        delete [] cstr;
        return err;
    }
    else
        return -1;
}

int send_low_battery_message()
{
    char* msg = "{\"message_id\":\"lowBattery\"}";
    if (webSock)
        return webSock->send(msg);
    else
        return -1;
}

int send_alert_message()
{
    string trespasser = "A58";
    string alert_type = "Urgent";
    string zone = "<Salle a manger>";
    
    char msg[200] = "{\"message_id\":\"alert\", \"alert_type\":\"" + alert_type + "\", \"target_id\":\"" + trespasser + "\", \"zone\":\"" + zone + "\"}";
    
    if (webSock)
    {
        char *cstr = new char[msg.length() + 1];
        strcpy(cstr, msg.c_str());
        int err = webSock->send(cstr);
        delete [] cstr;
        return err;
    }
    else
        return -1;
}

int main() {   
    
    // announce
    printf("Websocket Example v1.0.0\r\n");
    init_identity();
    printf("I am %s of type %s", id, type);
    init_web_socket();
    send_connection_message();
    send_low_battery_message();
    send_alert_message();
    
    while (true) {

        // blink... 
        led = !led; 
        wait(0.5);
        
    }
}