#include "mbed.h"       // Library for mbed
#include "Servo.h"      // Library for servo motor
#include "Keypad.h"     // Library for 4x4 matrix keypad
#include "TextLCD.h"    // Library for 16x2 LCD
#include <string>       // Library for string class

Servo myservo(PTB3);            // Signal pin of servo motor attach to pin PTB3 
DigitalIn IR_sensor(PTA12);     // IR obstacle sensor connect to digital pin PTA12
DigitalOut LED(PTD4);           // Green LED connect to digital pin PTD4
DigitalOut LCD(PTC12);          // Cathode pin of LCD connect to PTC12

// Keypad connection (col 0, col1, col2, col3, row0, row1, row2, row3)
Keypad keypad(PTC9,PTC8,PTA5,PTA4,PTD2,PTD0,PTD5,PTA13);
// LCD connection ( RS, E, D4, D5, D6, D7)
TextLCD lcd(PTE20, PTE21, PTE22, PTE23, PTE29, PTE30, TextLCD::LCD16x2); 

char pass_set[4] = {'1','2','3','4'};   // Predefined password
char password[4] ;                      // String used to store password input

int main() {                    // Main function
    char key, old_key;          // Declare char variables key and old_key
    int i=0,j=0;                // Declare integer variables i and j and initialize to 0
    int released = 1;           // Declare integer variable ‘released’ used to indicate whether the key is pressed
    int ret = 2;                // Declare integer variable ‘ret’ used for comparison of predefined password and input password
    myservo = 0.0;              // Initialize the position of servo motor to 0 (locked) 
    lcd.cls();                  // Clear the LCD
    
    while(IR_sensor == 1){      // No obstacle detected, IR_sensor returns 1
        LED = 0;                // Green LED turns off
        LCD = 1;                // Backlight of LCD turns off
    }
    // While loop is break once the IR_sensor returns 0 which means obstacle is detected 
    LED = 1;                        // Green LED turns on
    LCD = 0;                        // Backlight of LCD turns on
    lcd.printf("Welcome Home!");    // Print welcome message
    lcd.locate(0,1);                // Print message on second line
    lcd.printf("Enter Password.");  // Ask user to enter password
    wait(2);                        // Wait for 2 seconds
    lcd.cls();
    lcd.printf("Password Entered");
    
    while(1) {                      // Infinite loop
       key = keypad.ReadKey();      // Read the current key pressed from the keypad
       
        if (key == '\0'){           // If no key is pressed or all the keys are released
            released = 1;}          // Set the released
        
        if ((key != '\0') && (released == 1)){  //If a key is pressed and previous key is released
           if (key != old_key){                 // If the key pressed is different as the previous key
                password[i++] = key;            // Store the input key in password string
                lcd.locate(j++,1);              // Print the key pressed on LCD
                lcd.printf("%c",key);
                old_key = key;                  // Store the latest key pressed on old_key
                released = 0;}                  // Clear the flag indicate the key is still pressed
        }
        
       if (i == 4){                  // If the number of keys pressed is equal to 4
            // Compare the input password with predefined password
            // 4 is the number of character to be compared
            ret = strncmp(password, pass_set, 4); 
            wait(0.5);               // Wait for 0.5 seconds
        }
        
       if (ret ==0){                        // The input password matches the predefined password
           lcd.cls();                       // Print message on LCD
           lcd.printf("Password Correct");
           lcd.locate(0,1);
           lcd.printf("Access Allowed.");
           myservo = 1.0;                   // Rotate the servo motor to unlock the door
           wait(2);                         // Wait for 2 seconds
           main();                          // Jump back to main function to start everything again
        }
        else if (ret ==1){                  // The input password does not matches the predefined password
           lcd.cls();                        // Print message on LCD
           lcd.printf("Wrong Password.");
           lcd.locate(0,1);
           lcd.printf("Access Denied.");
           wait(2);                         // Wait for 2 seconds
           main();                          // Jump back to main function to start everything again
        } 
    }
}