#include "mbed.h"
#include "Motor.h"
#include "movement.h"

Serial pc(USBTX,USBRX);

DigitalOut myled(LED1);

AnalogIn rightsensorval(p15);
AnalogIn leftsensorval(p16);

DigitalOut rightsensorcontrol(p5);
DigitalOut leftsensorcontrol(p6);

Motor motor_right(p21,p7,p8);
Motor motor_left(p22,p9,p10);


volatile int rightspokecount = 0;
volatile int leftspokecount = 0;

volatile int rightspokecountrequired = 0;
volatile int leftspokecountrequired = 0;

volatile float rightmotorspeed = 1;
volatile float leftmotorspeed = 1;

Ticker charge_period;
Ticker discharge_period;

int main() {
    
    QTIsensor_init();
    charge_period.attach(&QTIsensor_charge,0.02);
    wait_ms(0.5);
    discharge_period.attach(&QTIsensor_discharge,0.02);
    while(1) {
        //calibratemotors();
        myled = 1;
        wait(0.4);
        move(2);
        //motors_stop();
        while((rightspokecount < rightspokecountrequired) || (leftspokecount < leftspokecountrequired)){
            pc.printf("right = %d, left =%d\n\r",rightspokecount,leftspokecount);
            float right = rightsensorval;
            float left = leftsensorval;
            pc.printf("rightval = %f, leftval =%f\n\r",right,left);
            wait(0.2);
        }
        motors_stop();
        wait(1);
        move(-2);
        while((rightspokecount < rightspokecountrequired) || (leftspokecount < leftspokecountrequired)){
            pc.printf("right = %d, left =%d\n\r",rightspokecount,leftspokecount);
            float right = rightsensorval;
            float left = leftsensorval;
            pc.printf("rightval = %f, leftval =%f\n\r",right,left);
            wait(0.2);
        }
        motors_stop();
        //motor_reset = 1;
        //goforward(right,left,0.5);
        //wait(1.5);
        
        myled = 0;
        wait(0.4);
        //gobackward(right,left,0.5);
        //wait(1.5);
    }
}



