#include "mbed.h"
#include "Motor.h"

#ifndef _MOVEMENT_H
#define _MOVEMENT_H

#define qtithreshold 0.3

#define spokeconversionfactor 0.5


extern AnalogIn rightsensorval;
extern AnalogIn leftsensorval;

extern DigitalOut rightsensorcontrol;
extern DigitalOut leftsensorcontrol;

extern DigitalOut motor_reset;
extern Motor motor_right;
extern Motor motor_left;

extern Serial pc;

volatile extern int rightspokecount;
volatile extern int leftspokecount;

volatile extern int rightspokecountrequired;
volatile extern int leftspokecountrequired;

volatile extern float rightmotorspeed;
volatile extern float leftmotorspeed;

void moveforward(Motor right,float speed);
void movebackward(Motor right,float speed);
void move(int distance);
void motors_stop();
void calibratemotors();


void QTIsensor_init();
void QTIsensor_charge();
void QTIsensor_discharge();

#endif
 
