/**
 * @file tls_cipher_suites.c
 * @brief TLS cipher suites
 *
 * @section License
 *
 * Copyright (C) 2010-2017 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSL Open.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 1.7.6
 **/

//Switch to the appropriate trace level
#define TRACE_LEVEL TLS_TRACE_LEVEL

//Dependencies
#include "tls.h"
#include "tls_cipher_suites.h"
#include "md5.h"
#include "sha1.h"
#include "sha256.h"
#include "sha384.h"
#include "rc4.h"
#include "idea.h"
#include "des.h"
#include "des3.h"
#include "aes.h"
#include "camellia.h"
#include "seed.h"
#include "aria.h"
#include "debug.h"

//Check SSL library configuration
#if (TLS_SUPPORT == ENABLED)

//List of supported cipher suites
const TlsCipherSuiteInfo tlsSupportedCipherSuites[] =
{
//TLS_RSA_WITH_RC4_128_MD5 cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_MD5_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_RC4_128_MD5, TLS_KEY_EXCH_RSA, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, MD5_HASH_ALGO, NULL, 16, 16, 0, 0, 0, 12),
#endif

//TLS_RSA_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_RC4_128_SHA, TLS_KEY_EXCH_RSA, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_RSA_WITH_IDEA_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_IDEA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_IDEA_CBC_SHA, TLS_KEY_EXCH_RSA, IDEA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 8, 8, 0, 12),
#endif

//TLS_RSA_WITH_DES_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_DES_CBC_SHA, TLS_KEY_EXCH_RSA, DES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 8, 8, 8, 0, 12),
#endif

//TLS_RSA_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_RSA, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_RSA_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_AES_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_AES_128_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_128_CCM, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_AES_256_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_256_CCM, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_AES_128_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_128_CCM_8, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 8, 12),
#endif

//TLS_RSA_WITH_AES_256_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_256_CCM_8, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 8, 12),
#endif

//TLS_RSA_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_SEED_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_SEED_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_SEED_CBC_SHA, TLS_KEY_EXCH_RSA, SEED_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_DES_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, DES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 8, 8, 8, 0, 12),
#endif

//TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_DHE_RSA_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_AES_128_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_128_CCM, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_AES_256_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_256_CCM, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_AES_128_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_128_CCM_8, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 8, 12),
#endif

//TLS_DHE_RSA_WITH_AES_256_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_256_CCM_8, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 8, 12),
#endif

//TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_DHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_SEED_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_SEED_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_SEED_CBC_SHA, TLS_KEY_EXCH_DHE_RSA, SEED_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_DHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_RSA_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_DHE_RSA, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_DHE_DSS_WITH_DES_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, DES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 8, 8, 8, 0, 12),
#endif

//TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_DHE_DSS_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_DHE_DSS, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_DSS, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_DSS_WITH_SEED_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_SEED_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_SEED_CBC_SHA, TLS_KEY_EXCH_DHE_DSS, SEED_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_DSS, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_DHE_DSS, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_DSS, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_DSS_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_DSS, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_RC4_128_MD5 cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_MD5_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_RC4_128_MD5, TLS_KEY_EXCH_DH_ANON, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, MD5_HASH_ALGO, NULL, 16, 16, 0, 0, 0, 12),
#endif

//TLS_DH_anon_WITH_DES_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_DES_CBC_SHA, TLS_KEY_EXCH_DH_ANON, DES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 8, 8, 8, 0, 12),
#endif

//TLS_DH_anon_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_DH_ANON, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_DH_anon_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_AES_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_256_CBC_SHA256, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_DH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA256, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 32, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_DH_ANON, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_SEED_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_SEED_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_SEED_CBC_SHA, TLS_KEY_EXCH_DH_ANON, SEED_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_DH_ANON, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_DH_ANON, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DH_anon_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_DH_ANON, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DH_anon_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DH_ANON_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DH_ANON_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_DH_ANON, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_RC4_128_SHA, TLS_KEY_EXCH_ECDHE_RSA, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_ECDHE_RSA, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_RSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_RSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_RSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_RSA_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_ECDHE_RSA, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, TLS_KEY_EXCH_ECDHE_ECDSA, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_ECDHE_ECDSA, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_128_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_128_CCM, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_256_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_256_CCM, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 8, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 8, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_ECDHE_ECDSA, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_ECDSA_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_ECDHE_ECDSA, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_ECDH_anon_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDH_ANON_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDH_ANON_WITH_RC4_128_SHA, TLS_KEY_EXCH_ECDH_ANON, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_ECDH_ANON, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_ECDH_anon_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDH_ANON_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_ECDH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_ECDH_anon_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDH_ANON_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDH_ANON_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_ECDH_ANON, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_PSK_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_RC4_128_SHA, TLS_KEY_EXCH_PSK, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_PSK_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_PSK, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_PSK_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_AES_128_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_128_CCM, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_AES_256_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_256_CCM, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_AES_128_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_128_CCM_8, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 8, 12),
#endif

//TLS_PSK_WITH_AES_256_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_256_CCM_8, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 8, 12),
#endif

//TLS_PSK_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_PSK_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_PSK_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_PSK_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_PSK, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_RSA_PSK_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_RC4_128_SHA, TLS_KEY_EXCH_RSA_PSK, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_RSA_PSK, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_RSA_PSK_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_RSA_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_RSA_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_RSA_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_RSA_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_RSA_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_RSA_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_RSA_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_RSA_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_RSA_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_RSA_PSK_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_RSA_PSK, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_DHE_PSK_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_RC4_128_SHA, TLS_KEY_EXCH_DHE_PSK, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_DHE_PSK, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_DHE_PSK_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_AES_128_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_128_CCM, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_AES_256_CCM cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_256_CCM, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_AES_128_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_128_CCM_8, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 8, 12),
#endif

//TLS_DHE_PSK_WITH_AES_256_CCM_8 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CCM_8_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_256_CCM_8, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CCM, NULL, SHA256_HASH_ALGO, 0, 32, 4, 8, 8, 12),
#endif

//TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, TLS_KEY_EXCH_DHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_DHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_DHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_DHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, TLS_KEY_EXCH_DHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA256_HASH_ALGO, 0, 16, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_GCM_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, TLS_KEY_EXCH_DHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_GCM, NULL, SHA384_HASH_ALGO, 0, 32, 4, 8, 16, 12),
#endif

//TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_DHE_PSK_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_DHE_PSK, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif

//TLS_ECDHE_PSK_WITH_RC4_128_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_STREAM_CIPHER_SUPPORT == ENABLED && TLS_RC4_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_RC4_128_SHA, TLS_KEY_EXCH_ECDHE_PSK, RC4_CIPHER_ALGO, CIPHER_MODE_STREAM, SHA1_HASH_ALGO, NULL, 20, 16, 0, 0, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_3DES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_KEY_EXCH_ECDHE_PSK, DES3_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 24, 8, 8, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, TLS_KEY_EXCH_ECDHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA cipher suite
#if (TLS_MAX_VERSION >= SSL_VERSION_3_0 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA1_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, TLS_KEY_EXCH_ECDHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA1_HASH_ALGO, NULL, 20, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_AES_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_PSK, AES_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_CAMELLIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_PSK, CAMELLIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_KEY_EXCH_ECDHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA256_HASH_ALGO, SHA256_HASH_ALGO, 32, 16, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CBC_CIPHER_SUPPORT == ENABLED && TLS_ARIA_SUPPORT == ENABLED && TLS_SHA384_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_KEY_EXCH_ECDHE_PSK, ARIA_CIPHER_ALGO, CIPHER_MODE_CBC, SHA384_HASH_ALGO, SHA384_HASH_ALGO, 48, 32, 16, 16, 0, 12),
#endif

//TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 cipher suite
#if (TLS_MAX_VERSION >= TLS_VERSION_1_2 && TLS_ECDHE_PSK_SUPPORT == ENABLED && TLS_CHACHA20_POLY1305_SUPPORT == ENABLED && TLS_SHA256_SUPPORT == ENABLED)
   TLS_CIPHER_SUITE(TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256, TLS_KEY_EXCH_ECDHE_PSK, NULL, CIPHER_MODE_CHACHA20_POLY1305, NULL, SHA256_HASH_ALGO, 0, 32, 12, 0, 16, 12),
#endif
};


/**
 * @brief Determine the number of cipher suites supported
 * @return Number of supported cipher suites
 **/

uint_t tlsGetNumSupportedCipherSuites(void)
{
   //Return the number of supported cipher suites
   return arraysize(tlsSupportedCipherSuites);
}


/**
 * @brief Convert cipher suite identifier to string representation
 * @param[in] identifier Cipher suite identifier
 * @return Cipher suite name
 **/

const char_t *tlsGetCipherSuiteName(uint16_t identifier)
{
   uint_t i;

   //Default name for unknown cipher suites
   static const char_t defaultName[] = "Unknown";

   //Parse the list of supported cipher suite
   for(i = 0; i < arraysize(tlsSupportedCipherSuites); i++)
   {
      //The current cipher suite matches the specified identifier?
      if(tlsSupportedCipherSuites[i].identifier == identifier)
         return tlsSupportedCipherSuites[i].name;
   }

   //Unknown cipher suite...
   return defaultName;
}


/**
 * @brief Check whether a cipher suite is supported
 * @param[in] identifier Cipher suite identifier
 * @return TRUE if the specified cipher suite is supported, else FALSE
 **/

bool_t tlsIsCipherSuiteSupported(uint16_t identifier)
{
   uint_t i;

   //Parse the list of supported cipher suite
   for(i = 0; i < arraysize(tlsSupportedCipherSuites); i++)
   {
      //The current cipher suite matches the specified identifier?
      if(tlsSupportedCipherSuites[i].identifier == identifier)
         return TRUE;
   }

   //The specified cipher suite is not supported...
   return FALSE;
}


/**
 * @brief Check whether the specified identifier matches an ECC cipher suite
 * @param[in] identifier Cipher suite identifier
 * @return TRUE if the specified cipher suite is supported, else FALSE
 **/

bool_t tlsIsEccCipherSuite(uint16_t identifier)
{
   uint_t i;

   //Parse the list of supported cipher suite
   for(i = 0; i < arraysize(tlsSupportedCipherSuites); i++)
   {
      //The current cipher suite matches the specified identifier?
      if(tlsSupportedCipherSuites[i].identifier == identifier)
      {
         //ECC cipher suite?
         switch(tlsSupportedCipherSuites[i].keyExchMethod)
         {
         case TLS_KEY_EXCH_ECDH_RSA:
         case TLS_KEY_EXCH_ECDH_ECDSA:
         case TLS_KEY_EXCH_ECDH_ANON:
         case TLS_KEY_EXCH_ECDHE_RSA:
         case TLS_KEY_EXCH_ECDHE_ECDSA:
         case TLS_KEY_EXCH_ECDHE_PSK:
            return TRUE;
         default:
            return FALSE;
         }
      }
   }

   //Unknown cipher suite...
   return FALSE;
}

#endif

