#include "mbed.h"

//playing with servos...
// Controlling the servo position with a potenciometer.

// the servo must be powered from an external device, 
// since mbed, will cut it out when the  current goes up 400mA.
// just remember to ground the external batteries, chargers, ...
// to the GND pin. 

//  trick!:  when control signal goes to 0V. the servo goes freely and dont
// hold any stall torque!-> that could be useful sometimes, ... to load some
// mechanism, or as a safety measurement.
        

PwmOut myservo(p21); //PWM servo control signal goes here

//   ______       Position 0 degrees
//  |      |_______________________________________________
//  <-1ms->  0.05%duty cycle
//
//   __________________     Position 180 degrees
//  |                  |___________________________________
//  <-------2.1ms----->  0.1%aprox. duty cycle
//
//  <----------------------------20ms---------------------->



AnalogIn input(p20); //analog input is wired to a potenciometer, range 0->3.3V
                     //and the value is represented as a float, range 0->1.

//as the input range is from 0 to 1, and the PWM control, ranges is 
//from 0.05% to 0.1% is pretty easy make the control! 
//with the PWM .write() method,sets the duty cycle specified as a fload in range 0->1
//so, for the control only divide by 10 the input, is needed.


//some ultra-light blue leds, for adding a cool effect!
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
     float ain;    //ain-> Analog INput<- connected to a potenciometer for controlling the servo
     float period=20;
  
     myservo.period_ms(period);
     
    while (1) {
    
      ain=input.read();//the analog reading, is expressed as a float
                       // with values from 0 to 1. 1 stands for max. voltage= 3.3V
        
        if (ain<0.02){                   //if voltage is sooo low...
        led1=0; led2=0; led3=0; led4=0;  //no leds!
        ain=0;                           //no control signal-> no torque, so you can 
                                         //use it as safety measurement, or to manualy move the servo position.
        }
        else if ( ain>0.02 && ain<0.33){  // When the LED1 turns on, is because you have just hitted the 0 degrees position.
        led1=1; led2=0; led3=0; led4=0;   // LED1 will be on from 0 to 60 degrees. ... aprox. :)
        }
        else if ( ain>0.33 && ain<0.66){   // LED2 switch on, when you pass the 60 degrees.
        led1=1; led2=1; led3=0; led4=0;
        }
        else if ( ain>0.66 && ain<0.95){  // LED3 switch on, when you pass 120 degrees
        led1=1; led2=1; led3=1; led4=0;
        } 
        else {                           // LED4. you are at 180 degrees.
        led1=1; led2=2; led3=1; led4=1;
        }
        
        
        myservo.write(ain/10);
        
        } // end while(1)
    
}//end main()




